@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * File share information with Path, Username, and Password.
 * @property password Password credential used to connect to the share location.
 * @property path The folder path for this share.
 * @property userName User name credential to connect to the share location
 */
public data class FileShareResponse(
    public val password: String? = null,
    public val path: String,
    public val userName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.FileShareResponse):
            FileShareResponse = FileShareResponse(
            password = javaType.password().map({ args0 -> args0 }).orElse(null),
            path = javaType.path(),
            userName = javaType.userName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
