@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Database Migration Resource for SQL Database.
 * @property id
 * @property name
 * @property properties Database Migration Resource properties for SQL database.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type
 */
public data class GetDatabaseMigrationsSqlDbResult(
    public val id: String,
    public val name: String,
    public val properties: DatabaseMigrationPropertiesSqlDbResponse,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.GetDatabaseMigrationsSqlDbResult):
            GetDatabaseMigrationsSqlDbResult = GetDatabaseMigrationsSqlDbResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.datamigration.kotlin.outputs.DatabaseMigrationPropertiesSqlDbResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.datamigration.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
