@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Input for the task that gets TDE certificates in Base64 encoded format.
 * @property backupFileShare Backup file share information for file share to be used for temporarily storing files.
 * @property connectionInfo Connection information for SQL Server
 * @property selectedCertificates List containing certificate names and corresponding password to use for encrypting the exported certificate.
 */
public data class GetTdeCertificatesSqlTaskInputResponse(
    public val backupFileShare: FileShareResponse,
    public val connectionInfo: SqlConnectionInfoResponse,
    public val selectedCertificates: List<SelectedCertificateInputResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.GetTdeCertificatesSqlTaskInputResponse):
            GetTdeCertificatesSqlTaskInputResponse = GetTdeCertificatesSqlTaskInputResponse(
            backupFileShare = javaType.backupFileShare().let({ args0 ->
                com.pulumi.azurenative.datamigration.kotlin.outputs.FileShareResponse.Companion.toKotlin(args0)
            }),
            connectionInfo = javaType.connectionInfo().let({ args0 ->
                com.pulumi.azurenative.datamigration.kotlin.outputs.SqlConnectionInfoResponse.Companion.toKotlin(args0)
            }),
            selectedCertificates = javaType.selectedCertificates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.SelectedCertificateInputResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
