@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties required to create a connection to Azure SQL database Managed instance
 * @property managedInstanceResourceId Resource id for Azure SQL database Managed instance
 * @property password Password credential.
 * @property type Type of connection info
 * Expected value is 'MiSqlConnectionInfo'.
 * @property userName User name
 */
public data class MiSqlConnectionInfoResponse(
    public val managedInstanceResourceId: String,
    public val password: String? = null,
    public val type: String,
    public val userName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MiSqlConnectionInfoResponse):
            MiSqlConnectionInfoResponse = MiSqlConnectionInfoResponse(
            managedInstanceResourceId = javaType.managedInstanceResourceId(),
            password = javaType.password().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            userName = javaType.userName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
