@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Input for the task that migrates MySQL databases to Azure Database for MySQL for offline migrations
 * @property makeSourceServerReadOnly Setting to set the source server read only
 * @property optionalAgentSettings Optional parameters for fine tuning the data transfer rate during migration
 * @property selectedDatabases Databases to migrate
 * @property sourceConnectionInfo Connection information for source MySQL
 * @property startedOn Parameter to specify when the migration started
 * @property targetConnectionInfo Connection information for target Azure Database for MySQL
 */
public data class MigrateMySqlAzureDbForMySqlOfflineTaskInputResponse(
    public val makeSourceServerReadOnly: Boolean? = null,
    public val optionalAgentSettings: Map<String, String>? = null,
    public val selectedDatabases: List<MigrateMySqlAzureDbForMySqlOfflineDatabaseInputResponse>,
    public val sourceConnectionInfo: MySqlConnectionInfoResponse,
    public val startedOn: String? = null,
    public val targetConnectionInfo: MySqlConnectionInfoResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MigrateMySqlAzureDbForMySqlOfflineTaskInputResponse):
            MigrateMySqlAzureDbForMySqlOfflineTaskInputResponse =
            MigrateMySqlAzureDbForMySqlOfflineTaskInputResponse(
                makeSourceServerReadOnly = javaType.makeSourceServerReadOnly().map({ args0 -> args0 }).orElse(null),
                optionalAgentSettings = javaType.optionalAgentSettings().map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap(),
                selectedDatabases = javaType.selectedDatabases().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.MigrateMySqlAzureDbForMySqlOfflineDatabaseInputResponse.Companion.toKotlin(args0)
                    })
                }),
                sourceConnectionInfo = javaType.sourceConnectionInfo().let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.MySqlConnectionInfoResponse.Companion.toKotlin(args0)
                }),
                startedOn = javaType.startedOn().map({ args0 -> args0 }).orElse(null),
                targetConnectionInfo = javaType.targetConnectionInfo().let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.MySqlConnectionInfoResponse.Companion.toKotlin(args0)
                }),
            )
    }
}
