@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Database specific information for Oracle to Azure Database for PostgreSQL migration task inputs
 * @property caseManipulation How to handle object name casing: either Preserve or ToLower
 * @property migrationSetting Migration settings which tune the migration behavior
 * @property name Name of the migration pipeline
 * @property schemaName Name of the source schema
 * @property sourceSetting Source settings to tune source endpoint migration behavior
 * @property tableMap Mapping of source to target tables
 * @property targetDatabaseName Name of target database. Note: Target database will be truncated before starting migration.
 * @property targetSetting Target settings to tune target endpoint migration behavior
 */
public data class MigrateOracleAzureDbPostgreSqlSyncDatabaseInputResponse(
    public val caseManipulation: String? = null,
    public val migrationSetting: Map<String, String>? = null,
    public val name: String? = null,
    public val schemaName: String? = null,
    public val sourceSetting: Map<String, String>? = null,
    public val tableMap: Map<String, String>? = null,
    public val targetDatabaseName: String? = null,
    public val targetSetting: Map<String, String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MigrateOracleAzureDbPostgreSqlSyncDatabaseInputResponse):
            MigrateOracleAzureDbPostgreSqlSyncDatabaseInputResponse =
            MigrateOracleAzureDbPostgreSqlSyncDatabaseInputResponse(
                caseManipulation = javaType.caseManipulation().map({ args0 -> args0 }).orElse(null),
                migrationSetting = javaType.migrationSetting().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                schemaName = javaType.schemaName().map({ args0 -> args0 }).orElse(null),
                sourceSetting = javaType.sourceSetting().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                tableMap = javaType.tableMap().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                targetDatabaseName = javaType.targetDatabaseName().map({ args0 -> args0 }).orElse(null),
                targetSetting = javaType.targetSetting().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            )
    }
}
