@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dataIntegrityValidationResult Provides data integrity validation result between the source and target tables that are migrated.
 * @property endedOn Validation end time
 * @property id Result identifier
 * @property migrationId Migration Identifier
 * @property queryAnalysisValidationResult Results of some of the query execution result between source and target database
 * @property resultType Result type
 * Expected value is 'MigrationDatabaseLevelValidationOutput'.
 * @property schemaValidationResult Provides schema comparison result between source and target database
 * @property sourceDatabaseName Name of the source database
 * @property startedOn Validation start time
 * @property status Current status of validation at the database level
 * @property targetDatabaseName Name of the target database
 */
public data class MigrateSqlServerSqlDbTaskOutputDatabaseLevelValidationResultResponse(
    public val dataIntegrityValidationResult: DataIntegrityValidationResultResponse,
    public val endedOn: String,
    public val id: String,
    public val migrationId: String,
    public val queryAnalysisValidationResult: QueryAnalysisValidationResultResponse,
    public val resultType: String,
    public val schemaValidationResult: SchemaComparisonValidationResultResponse,
    public val sourceDatabaseName: String,
    public val startedOn: String,
    public val status: String,
    public val targetDatabaseName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MigrateSqlServerSqlDbTaskOutputDatabaseLevelValidationResultResponse):
            MigrateSqlServerSqlDbTaskOutputDatabaseLevelValidationResultResponse =
            MigrateSqlServerSqlDbTaskOutputDatabaseLevelValidationResultResponse(
                dataIntegrityValidationResult = javaType.dataIntegrityValidationResult().let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.DataIntegrityValidationResultResponse.Companion.toKotlin(args0)
                }),
                endedOn = javaType.endedOn(),
                id = javaType.id(),
                migrationId = javaType.migrationId(),
                queryAnalysisValidationResult = javaType.queryAnalysisValidationResult().let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.QueryAnalysisValidationResultResponse.Companion.toKotlin(args0)
                }),
                resultType = javaType.resultType(),
                schemaValidationResult = javaType.schemaValidationResult().let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.SchemaComparisonValidationResultResponse.Companion.toKotlin(args0)
                }),
                sourceDatabaseName = javaType.sourceDatabaseName(),
                startedOn = javaType.startedOn(),
                status = javaType.status(),
                targetDatabaseName = javaType.targetDatabaseName(),
            )
    }
}
