@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Specifies resource limits for the migration
 * @property maxParallelism The maximum number of work items (e.g. collection copies) that will be processed in parallel
 * @property minFreeCpu The percentage of CPU time that the migrator will try to avoid using, from 0 to 100
 * @property minFreeMemoryMb The number of megabytes of RAM that the migrator will try to avoid using
 */
public data class MongoDbThrottlingSettingsResponse(
    public val maxParallelism: Int? = null,
    public val minFreeCpu: Int? = null,
    public val minFreeMemoryMb: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MongoDbThrottlingSettingsResponse):
            MongoDbThrottlingSettingsResponse = MongoDbThrottlingSettingsResponse(
            maxParallelism = javaType.maxParallelism().map({ args0 -> args0 }).orElse(null),
            minFreeCpu = javaType.minFreeCpu().map({ args0 -> args0 }).orElse(null),
            minFreeMemoryMb = javaType.minFreeMemoryMb().map({ args0 -> args0 }).orElse(null),
        )
    }
}
