@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Base class for file properties.
 * @property extension Optional File extension. If submitted it should not have a leading period and must match the extension from filePath.
 * @property filePath Relative path of this file resource. This property can be set when creating or updating the file resource.
 * @property lastModified Modification DateTime.
 * @property mediaType File content type. This property can be modified to reflect the file content type.
 * @property size File size.
 */
public data class ProjectFilePropertiesResponse(
    public val extension: String? = null,
    public val filePath: String? = null,
    public val lastModified: String,
    public val mediaType: String? = null,
    public val size: Double,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ProjectFilePropertiesResponse):
            ProjectFilePropertiesResponse = ProjectFilePropertiesResponse(
            extension = javaType.extension().map({ args0 -> args0 }).orElse(null),
            filePath = javaType.filePath().map({ args0 -> args0 }).orElse(null),
            lastModified = javaType.lastModified(),
            mediaType = javaType.mediaType().map({ args0 -> args0 }).orElse(null),
            size = javaType.size(),
        )
    }
}
