@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Describes query analysis results for execution in source and target
 * @property queryText Query text retrieved from the source server
 * @property sourceResult Query analysis result from the source
 * @property statementsInBatch Total no. of statements in the batch
 * @property targetResult Query analysis result from the target
 */
public data class QueryExecutionResultResponse(
    public val queryText: String? = null,
    public val sourceResult: ExecutionStatisticsResponse? = null,
    public val statementsInBatch: Double? = null,
    public val targetResult: ExecutionStatisticsResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.QueryExecutionResultResponse):
            QueryExecutionResultResponse = QueryExecutionResultResponse(
            queryText = javaType.queryText().map({ args0 -> args0 }).orElse(null),
            sourceResult = javaType.sourceResult().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.ExecutionStatisticsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            statementsInBatch = javaType.statementsInBatch().map({ args0 -> args0 }).orElse(null),
            targetResult = javaType.targetResult().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.ExecutionStatisticsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
