@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin

import com.pulumi.azurenative.dataprotection.BackupInstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * BackupInstance Resource
 * Azure REST API version: 2023-01-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2023-04-01-preview, 2023-05-01, 2023-06-01-preview, 2023-08-01, 2023-08-01-preview.
 * ## Example Usage
 * ### Create BackupInstance
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var backupInstance = new AzureNative.DataProtection.BackupInstance("backupInstance", new()
 *     {
 *         BackupInstanceName = "testInstance1",
 *         Properties = new AzureNative.DataProtection.Inputs.BackupInstanceArgs
 *         {
 *             DataSourceInfo = new AzureNative.DataProtection.Inputs.DatasourceArgs
 *             {
 *                 DatasourceType = "Microsoft.DBforPostgreSQL/servers/databases",
 *                 ObjectType = "Datasource",
 *                 ResourceID = "/subscriptions/f75d8d8b-6735-4697-82e1-1a7a3ff0d5d4/resourceGroups/viveksipgtest/providers/Microsoft.DBforPostgreSQL/servers/viveksipgtest/databases/testdb",
 *                 ResourceLocation = "",
 *                 ResourceName = "testdb",
 *                 ResourceType = "Microsoft.DBforPostgreSQL/servers/databases",
 *                 ResourceUri = "",
 *             },
 *             DataSourceSetInfo = new AzureNative.DataProtection.Inputs.DatasourceSetArgs
 *             {
 *                 DatasourceType = "Microsoft.DBforPostgreSQL/servers/databases",
 *                 ObjectType = "DatasourceSet",
 *                 ResourceID = "/subscriptions/f75d8d8b-6735-4697-82e1-1a7a3ff0d5d4/resourceGroups/viveksipgtest/providers/Microsoft.DBforPostgreSQL/servers/viveksipgtest",
 *                 ResourceLocation = "",
 *                 ResourceName = "viveksipgtest",
 *                 ResourceType = "Microsoft.DBforPostgreSQL/servers",
 *                 ResourceUri = "",
 *             },
 *             DatasourceAuthCredentials =
 *             {
 *                 { "objectType", "SecretStoreBasedAuthCredentials" },
 *                 { "secretStoreResource", new AzureNative.DataProtection.Inputs.SecretStoreResourceArgs
 *                 {
 *                     SecretStoreType = "AzureKeyVault",
 *                     Uri = "https://samplevault.vault.azure.net/secrets/credentials",
 *                 } },
 *             },
 *             FriendlyName = "harshitbi2",
 *             ObjectType = "BackupInstance",
 *             PolicyInfo = new AzureNative.DataProtection.Inputs.PolicyInfoArgs
 *             {
 *                 PolicyId = "/subscriptions/04cf684a-d41f-4550-9f70-7708a3a2283b/resourceGroups/000pikumar/providers/Microsoft.DataProtection/Backupvaults/PratikPrivatePreviewVault1/backupPolicies/PratikPolicy1",
 *                 PolicyParameters = new AzureNative.DataProtection.Inputs.PolicyParametersArgs
 *                 {
 *                     DataStoreParametersList = new[]
 *                     {
 *                         {
 *                             { "dataStoreType", "OperationalStore" },
 *                             { "objectType", "AzureOperationalStoreParameters" },
 *                             { "resourceGroupId", "/subscriptions/f75d8d8b-6735-4697-82e1-1a7a3ff0d5d4/resourceGroups/viveksipgtest" },
 *                         },
 *                     },
 *                 },
 *             },
 *             ValidationType = "ShallowValidation",
 *         },
 *         ResourceGroupName = "000pikumar",
 *         Tags =
 *         {
 *             { "key1", "val1" },
 *         },
 *         VaultName = "PratikPrivatePreviewVault1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dataprotection/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := dataprotection.NewBackupInstance(ctx, "backupInstance", &dataprotection.BackupInstanceArgs{
 * BackupInstanceName: pulumi.String("testInstance1"),
 * Properties: dataprotection.BackupInstanceResponse{
 * DataSourceInfo: &dataprotection.DatasourceArgs{
 * DatasourceType: pulumi.String("Microsoft.DBforPostgreSQL/servers/databases"),
 * ObjectType: pulumi.String("Datasource"),
 * ResourceID: pulumi.String("/subscriptions/f75d8d8b-6735-4697-82e1-1a7a3ff0d5d4/resourceGroups/viveksipgtest/providers/Microsoft.DBforPostgreSQL/servers/viveksipgtest/databases/testdb"),
 * ResourceLocation: pulumi.String(""),
 * ResourceName: pulumi.String("testdb"),
 * ResourceType: pulumi.String("Microsoft.DBforPostgreSQL/servers/databases"),
 * ResourceUri: pulumi.String(""),
 * },
 * DataSourceSetInfo: &dataprotection.DatasourceSetArgs{
 * DatasourceType: pulumi.String("Microsoft.DBforPostgreSQL/servers/databases"),
 * ObjectType: pulumi.String("DatasourceSet"),
 * ResourceID: pulumi.String("/subscriptions/f75d8d8b-6735-4697-82e1-1a7a3ff0d5d4/resourceGroups/viveksipgtest/providers/Microsoft.DBforPostgreSQL/servers/viveksipgtest"),
 * ResourceLocation: pulumi.String(""),
 * ResourceName: pulumi.String("viveksipgtest"),
 * ResourceType: pulumi.String("Microsoft.DBforPostgreSQL/servers"),
 * ResourceUri: pulumi.String(""),
 * },
 * DatasourceAuthCredentials: interface{}{
 * ObjectType: pulumi.String("SecretStoreBasedAuthCredentials"),
 * SecretStoreResource: &dataprotection.SecretStoreResourceArgs{
 * SecretStoreType: pulumi.String("AzureKeyVault"),
 * Uri: pulumi.String("https://samplevault.vault.azure.net/secrets/credentials"),
 * },
 * },
 * FriendlyName: pulumi.String("harshitbi2"),
 * ObjectType: pulumi.String("BackupInstance"),
 * PolicyInfo: interface{}{
 * PolicyId: pulumi.String("/subscriptions/04cf684a-d41f-4550-9f70-7708a3a2283b/resourceGroups/000pikumar/providers/Microsoft.DataProtection/Backupvaults/PratikPrivatePreviewVault1/backupPolicies/PratikPolicy1"),
 * PolicyParameters: interface{}{
 * DataStoreParametersList: []dataprotection.AzureOperationalStoreParametersArgs{
 * {
 * DataStoreType: pulumi.String("OperationalStore"),
 * ObjectType: pulumi.String("AzureOperationalStoreParameters"),
 * ResourceGroupId: pulumi.String("/subscriptions/f75d8d8b-6735-4697-82e1-1a7a3ff0d5d4/resourceGroups/viveksipgtest"),
 * },
 * },
 * },
 * },
 * ValidationType: pulumi.String("ShallowValidation"),
 * },
 * ResourceGroupName: pulumi.String("000pikumar"),
 * Tags: pulumi.StringMap{
 * "key1": pulumi.String("val1"),
 * },
 * VaultName: pulumi.String("PratikPrivatePreviewVault1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dataprotection.BackupInstance;
 * import com.pulumi.azurenative.dataprotection.BackupInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var backupInstance = new BackupInstance("backupInstance", BackupInstanceArgs.builder()
 *             .backupInstanceName("testInstance1")
 *             .properties(Map.ofEntries(
 *                 Map.entry("dataSourceInfo", Map.ofEntries(
 *                     Map.entry("datasourceType", "Microsoft.DBforPostgreSQL/servers/databases"),
 *                     Map.entry("objectType", "Datasource"),
 *                     Map.entry("resourceID", "/subscriptions/f75d8d8b-6735-4697-82e1-1a7a3ff0d5d4/resourceGroups/viveksipgtest/providers/Microsoft.DBforPostgreSQL/servers/viveksipgtest/databases/testdb"),
 *                     Map.entry("resourceLocation", ""),
 *                     Map.entry("resourceName", "testdb"),
 *                     Map.entry("resourceType", "Microsoft.DBforPostgreSQL/servers/databases"),
 *                     Map.entry("resourceUri", "")
 *                 )),
 *                 Map.entry("dataSourceSetInfo", Map.ofEntries(
 *                     Map.entry("datasourceType", "Microsoft.DBforPostgreSQL/servers/databases"),
 *                     Map.entry("objectType", "DatasourceSet"),
 *                     Map.entry("resourceID", "/subscriptions/f75d8d8b-6735-4697-82e1-1a7a3ff0d5d4/resourceGroups/viveksipgtest/providers/Microsoft.DBforPostgreSQL/servers/viveksipgtest"),
 *                     Map.entry("resourceLocation", ""),
 *                     Map.entry("resourceName", "viveksipgtest"),
 *                     Map.entry("resourceType", "Microsoft.DBforPostgreSQL/servers"),
 *                     Map.entry("resourceUri", "")
 *                 )),
 *                 Map.entry("datasourceAuthCredentials", Map.ofEntries(
 *                     Map.entry("objectType", "SecretStoreBasedAuthCredentials"),
 *                     Map.entry("secretStoreResource", Map.ofEntries(
 *                         Map.entry("secretStoreType", "AzureKeyVault"),
 *                         Map.entry("uri", "https://samplevault.vault.azure.net/secrets/credentials")
 *                     ))
 *                 )),
 *                 Map.entry("friendlyName", "harshitbi2"),
 *                 Map.entry("objectType", "BackupInstance"),
 *                 Map.entry("policyInfo", Map.ofEntries(
 *                     Map.entry("policyId", "/subscriptions/04cf684a-d41f-4550-9f70-7708a3a2283b/resourceGroups/000pikumar/providers/Microsoft.DataProtection/Backupvaults/PratikPrivatePreviewVault1/backupPolicies/PratikPolicy1"),
 *                     Map.entry("policyParameters", Map.of("dataStoreParametersList", Map.ofEntries(
 *                         Map.entry("dataStoreType", "OperationalStore"),
 *                         Map.entry("objectType", "AzureOperationalStoreParameters"),
 *                         Map.entry("resourceGroupId", "/subscriptions/f75d8d8b-6735-4697-82e1-1a7a3ff0d5d4/resourceGroups/viveksipgtest")
 *                     )))
 *                 )),
 *                 Map.entry("validationType", "ShallowValidation")
 *             ))
 *             .resourceGroupName("000pikumar")
 *             .tags(Map.of("key1", "val1"))
 *             .vaultName("PratikPrivatePreviewVault1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dataprotection:BackupInstance harshitbi2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/backupVaults/{vaultName}/backupInstances/{backupInstanceName}
 * ```
 * @property backupInstanceName The name of the backup instance.
 * @property properties BackupInstanceResource properties
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Proxy Resource tags.
 * @property vaultName The name of the backup vault.
 */
public data class BackupInstanceArgs(
    public val backupInstanceName: Output<String>? = null,
    public val properties:
    Output<com.pulumi.azurenative.dataprotection.kotlin.inputs.BackupInstanceArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vaultName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.BackupInstanceArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.BackupInstanceArgs =
        com.pulumi.azurenative.dataprotection.BackupInstanceArgs.builder()
            .backupInstanceName(backupInstanceName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vaultName(vaultName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BackupInstanceArgs].
 */
@PulumiTagMarker
public class BackupInstanceArgsBuilder internal constructor() {
    private var backupInstanceName: Output<String>? = null

    private var properties:
        Output<com.pulumi.azurenative.dataprotection.kotlin.inputs.BackupInstanceArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vaultName: Output<String>? = null

    /**
     * @param value The name of the backup instance.
     */
    @JvmName("svwgmwwusoxaliwq")
    public suspend fun backupInstanceName(`value`: Output<String>) {
        this.backupInstanceName = value
    }

    /**
     * @param value BackupInstanceResource properties
     */
    @JvmName("igajsybxmmxaasxa")
    public suspend
    fun properties(`value`: Output<com.pulumi.azurenative.dataprotection.kotlin.inputs.BackupInstanceArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wqnluhtwagrvgouq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Proxy Resource tags.
     */
    @JvmName("pabsathysnkaspro")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the backup vault.
     */
    @JvmName("mwghwyytmvtvfxwx")
    public suspend fun vaultName(`value`: Output<String>) {
        this.vaultName = value
    }

    /**
     * @param value The name of the backup instance.
     */
    @JvmName("ncadjkfitfuftnsa")
    public suspend fun backupInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupInstanceName = mapped
    }

    /**
     * @param value BackupInstanceResource properties
     */
    @JvmName("kyyceberlnubwoym")
    public suspend
    fun properties(`value`: com.pulumi.azurenative.dataprotection.kotlin.inputs.BackupInstanceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument BackupInstanceResource properties
     */
    @JvmName("ydqeofeieteilnmc")
    public suspend
    fun properties(argument: suspend com.pulumi.azurenative.dataprotection.kotlin.inputs.BackupInstanceArgsBuilder.() -> Unit) {
        val toBeMapped =
            com.pulumi.azurenative.dataprotection.kotlin.inputs.BackupInstanceArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dtvnojbumfkqkjsy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Proxy Resource tags.
     */
    @JvmName("mtnpcmnggyitknfd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Proxy Resource tags.
     */
    @JvmName("wtoxyohjxnxhrpxc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the backup vault.
     */
    @JvmName("msfnfvomdjorkvof")
    public suspend fun vaultName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultName = mapped
    }

    internal fun build(): BackupInstanceArgs = BackupInstanceArgs(
        backupInstanceName = backupInstanceName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
        vaultName = vaultName,
    )
}
