@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin

import com.pulumi.azurenative.dataprotection.kotlin.outputs.BackupPolicyResponse
import com.pulumi.azurenative.dataprotection.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.dataprotection.kotlin.outputs.BackupPolicyResponse.Companion.toKotlin as backupPolicyResponseToKotlin
import com.pulumi.azurenative.dataprotection.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [BackupPolicy].
 */
@PulumiTagMarker
public class BackupPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BackupPolicyArgs = BackupPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BackupPolicyArgsBuilder.() -> Unit) {
        val builder = BackupPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BackupPolicy {
        val builtJavaResource =
            com.pulumi.azurenative.dataprotection.BackupPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BackupPolicy(builtJavaResource)
    }
}

/**
 * BaseBackupPolicy resource
 * Azure REST API version: 2023-01-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2023-04-01-preview, 2023-05-01, 2023-06-01-preview, 2023-08-01, 2023-08-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate BackupPolicy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var backupPolicy = new AzureNative.DataProtection.BackupPolicy("backupPolicy", new()
 *     {
 *         BackupPolicyName = "OSSDBPolicy",
 *         Properties = new AzureNative.DataProtection.Inputs.BackupPolicyArgs
 *         {
 *             DatasourceTypes = new[]
 *             {
 *                 "OssDB",
 *             },
 *             ObjectType = "BackupPolicy",
 *             PolicyRules =
 *             {
 *                 new AzureNative.DataProtection.Inputs.AzureBackupRuleArgs
 *                 {
 *                     BackupParameters = new AzureNative.DataProtection.Inputs.AzureBackupParamsArgs
 *                     {
 *                         BackupType = "Full",
 *                         ObjectType = "AzureBackupParams",
 *                     },
 *                     DataStore = new AzureNative.DataProtection.Inputs.DataStoreInfoBaseArgs
 *                     {
 *                         DataStoreType = "VaultStore",
 *                         ObjectType = "DataStoreInfoBase",
 *                     },
 *                     Name = "BackupWeekly",
 *                     ObjectType = "AzureBackupRule",
 *                     Trigger = new AzureNative.DataProtection.Inputs.ScheduleBasedTriggerContextArgs
 *                     {
 *                         ObjectType = "ScheduleBasedTriggerContext",
 *                         Schedule = new AzureNative.DataProtection.Inputs.BackupScheduleArgs
 *                         {
 *                             RepeatingTimeIntervals = new[]
 *                             {
 *                                 "R/2019-11-20T08:00:00-08:00/P1W",
 *                             },
 *                         },
 *                         TaggingCriteria = new[]
 *                         {
 *                             new AzureNative.DataProtection.Inputs.TaggingCriteriaArgs
 *                             {
 *                                 IsDefault = true,
 *                                 TagInfo = new AzureNative.DataProtection.Inputs.RetentionTagArgs
 *                                 {
 *                                     TagName = "Default",
 *                                 },
 *                                 TaggingPriority = 99,
 *                             },
 *                             new AzureNative.DataProtection.Inputs.TaggingCriteriaArgs
 *                             {
 *                                 Criteria = new[]
 *                                 {
 *                                     new AzureNative.DataProtection.Inputs.ScheduleBasedBackupCriteriaArgs
 *                                     {
 *                                         DaysOfTheWeek = new[]
 *                                         {
 *                                             "Sunday",
 *                                         },
 *                                         ObjectType = "ScheduleBasedBackupCriteria",
 *                                         ScheduleTimes = new[]
 *                                         {
 *                                             "2019-03-01T13:00:00Z",
 *                                         },
 *                                     },
 *                                 },
 *                                 IsDefault = false,
 *                                 TagInfo = new AzureNative.DataProtection.Inputs.RetentionTagArgs
 *                                 {
 *                                     TagName = "Weekly",
 *                                 },
 *                                 TaggingPriority = 20,
 *                             },
 *                         },
 *                     },
 *                 },
 *                 new AzureNative.DataProtection.Inputs.AzureRetentionRuleArgs
 *                 {
 *                     IsDefault = true,
 *                     Lifecycles = new[]
 *                     {
 *                         new AzureNative.DataProtection.Inputs.SourceLifeCycleArgs
 *                         {
 *                             DeleteAfter = new AzureNative.DataProtection.Inputs.AbsoluteDeleteOptionArgs
 *                             {
 *                                 Duration = "P1W",
 *                                 ObjectType = "AbsoluteDeleteOption",
 *                             },
 *                             SourceDataStore = new AzureNative.DataProtection.Inputs.DataStoreInfoBaseArgs
 *                             {
 *                                 DataStoreType = "VaultStore",
 *                                 ObjectType = "DataStoreInfoBase",
 *                             },
 *                         },
 *                     },
 *                     Name = "Default",
 *                     ObjectType = "AzureRetentionRule",
 *                 },
 *                 new AzureNative.DataProtection.Inputs.AzureRetentionRuleArgs
 *                 {
 *                     IsDefault = false,
 *                     Lifecycles = new[]
 *                     {
 *                         new AzureNative.DataProtection.Inputs.SourceLifeCycleArgs
 *                         {
 *                             DeleteAfter = new AzureNative.DataProtection.Inputs.AbsoluteDeleteOptionArgs
 *                             {
 *                                 Duration = "P12W",
 *                                 ObjectType = "AbsoluteDeleteOption",
 *                             },
 *                             SourceDataStore = new AzureNative.DataProtection.Inputs.DataStoreInfoBaseArgs
 *                             {
 *                                 DataStoreType = "VaultStore",
 *                                 ObjectType = "DataStoreInfoBase",
 *                             },
 *                         },
 *                     },
 *                     Name = "Weekly",
 *                     ObjectType = "AzureRetentionRule",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "000pikumar",
 *         VaultName = "PrivatePreviewVault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dataprotection/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := dataprotection.NewBackupPolicy(ctx, "backupPolicy", &dataprotection.BackupPolicyArgs{
 * BackupPolicyName: pulumi.String("OSSDBPolicy"),
 * Properties: interface{}{
 * DatasourceTypes: pulumi.StringArray{
 * pulumi.String("OssDB"),
 * },
 * ObjectType: pulumi.String("BackupPolicy"),
 * PolicyRules: pulumi.Array{
 * dataprotection.AzureBackupRule{
 * BackupParameters: dataprotection.AzureBackupParams{
 * BackupType: "Full",
 * ObjectType: "AzureBackupParams",
 * },
 * DataStore: dataprotection.DataStoreInfoBase{
 * DataStoreType: "VaultStore",
 * ObjectType: "DataStoreInfoBase",
 * },
 * Name: "BackupWeekly",
 * ObjectType: "AzureBackupRule",
 * Trigger: dataprotection.ScheduleBasedTriggerContext{
 * ObjectType: "ScheduleBasedTriggerContext",
 * Schedule: dataprotection.BackupSchedule{
 * RepeatingTimeIntervals: []string{
 * "R/2019-11-20T08:00:00-08:00/P1W",
 * },
 * },
 * TaggingCriteria: []dataprotection.TaggingCriteria{
 * {
 * IsDefault: true,
 * TagInfo: {
 * TagName: "Default",
 * },
 * TaggingPriority: 99,
 * },
 * {
 * Criteria: []dataprotection.ScheduleBasedBackupCriteria{
 * {
 * DaysOfTheWeek: []dataprotection.DayOfWeek{
 * "Sunday",
 * },
 * ObjectType: "ScheduleBasedBackupCriteria",
 * ScheduleTimes: []string{
 * "2019-03-01T13:00:00Z",
 * },
 * },
 * },
 * IsDefault: false,
 * TagInfo: {
 * TagName: "Weekly",
 * },
 * TaggingPriority: 20,
 * },
 * },
 * },
 * },
 * dataprotection.AzureRetentionRule{
 * IsDefault: true,
 * Lifecycles: []dataprotection.SourceLifeCycle{
 * {
 * DeleteAfter: {
 * Duration: "P1W",
 * ObjectType: "AbsoluteDeleteOption",
 * },
 * SourceDataStore: {
 * DataStoreType: "VaultStore",
 * ObjectType: "DataStoreInfoBase",
 * },
 * },
 * },
 * Name: "Default",
 * ObjectType: "AzureRetentionRule",
 * },
 * dataprotection.AzureRetentionRule{
 * IsDefault: false,
 * Lifecycles: []dataprotection.SourceLifeCycle{
 * {
 * DeleteAfter: {
 * Duration: "P12W",
 * ObjectType: "AbsoluteDeleteOption",
 * },
 * SourceDataStore: {
 * DataStoreType: "VaultStore",
 * ObjectType: "DataStoreInfoBase",
 * },
 * },
 * },
 * Name: "Weekly",
 * ObjectType: "AzureRetentionRule",
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("000pikumar"),
 * VaultName: pulumi.String("PrivatePreviewVault"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dataprotection.BackupPolicy;
 * import com.pulumi.azurenative.dataprotection.BackupPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var backupPolicy = new BackupPolicy("backupPolicy", BackupPolicyArgs.builder()
 *             .backupPolicyName("OSSDBPolicy")
 *             .properties(Map.ofEntries(
 *                 Map.entry("datasourceTypes", "OssDB"),
 *                 Map.entry("objectType", "BackupPolicy"),
 *                 Map.entry("policyRules",
 *                     Map.ofEntries(
 *                         Map.entry("backupParameters", Map.ofEntries(
 *                             Map.entry("backupType", "Full"),
 *                             Map.entry("objectType", "AzureBackupParams")
 *                         )),
 *                         Map.entry("dataStore", Map.ofEntries(
 *                             Map.entry("dataStoreType", "VaultStore"),
 *                             Map.entry("objectType", "DataStoreInfoBase")
 *                         )),
 *                         Map.entry("name", "BackupWeekly"),
 *                         Map.entry("objectType", "AzureBackupRule"),
 *                         Map.entry("trigger", Map.ofEntries(
 *                             Map.entry("objectType", "ScheduleBasedTriggerContext"),
 *                             Map.entry("schedule", Map.of("repeatingTimeIntervals", "R/2019-11-20T08:00:00-08:00/P1W")),
 *                             Map.entry("taggingCriteria",
 *                                 Map.ofEntries(
 *                                     Map.entry("isDefault", true),
 *                                     Map.entry("tagInfo", Map.of("tagName", "Default")),
 *                                     Map.entry("taggingPriority", 99)
 *                                 ),
 *                                 Map.ofEntries(
 *                                     Map.entry("criteria", Map.ofEntries(
 *                                         Map.entry("daysOfTheWeek", "Sunday"),
 *                                         Map.entry("objectType", "ScheduleBasedBackupCriteria"),
 *                                         Map.entry("scheduleTimes", "2019-03-01T13:00:00Z")
 *                                     )),
 *                                     Map.entry("isDefault", false),
 *                                     Map.entry("tagInfo", Map.of("tagName", "Weekly")),
 *                                     Map.entry("taggingPriority", 20)
 *                                 ))
 *                         ))
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("isDefault", true),
 *                         Map.entry("lifecycles", Map.ofEntries(
 *                             Map.entry("deleteAfter", Map.ofEntries(
 *                                 Map.entry("duration", "P1W"),
 *                                 Map.entry("objectType", "AbsoluteDeleteOption")
 *                             )),
 *                             Map.entry("sourceDataStore", Map.ofEntries(
 *                                 Map.entry("dataStoreType", "VaultStore"),
 *                                 Map.entry("objectType", "DataStoreInfoBase")
 *                             ))
 *                         )),
 *                         Map.entry("name", "Default"),
 *                         Map.entry("objectType", "AzureRetentionRule")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("isDefault", false),
 *                         Map.entry("lifecycles", Map.ofEntries(
 *                             Map.entry("deleteAfter", Map.ofEntries(
 *                                 Map.entry("duration", "P12W"),
 *                                 Map.entry("objectType", "AbsoluteDeleteOption")
 *                             )),
 *                             Map.entry("sourceDataStore", Map.ofEntries(
 *                                 Map.entry("dataStoreType", "VaultStore"),
 *                                 Map.entry("objectType", "DataStoreInfoBase")
 *                             ))
 *                         )),
 *                         Map.entry("name", "Weekly"),
 *                         Map.entry("objectType", "AzureRetentionRule")
 *                     ))
 *             ))
 *             .resourceGroupName("000pikumar")
 *             .vaultName("PrivatePreviewVault")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dataprotection:BackupPolicy OSSDBPolicy /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/backupVaults/{vaultName}/backupPolicies/{backupPolicyName}
 * ```
 */
public class BackupPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.dataprotection.BackupPolicy,
) : KotlinCustomResource(javaResource, BackupPolicyMapper) {
    /**
     * Resource name associated with the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * BaseBackupPolicyResource properties
     */
    public val properties: Output<BackupPolicyResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                backupPolicyResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object BackupPolicyMapper : ResourceMapper<BackupPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.dataprotection.BackupPolicy::class == javaResource::class

    override fun map(javaResource: Resource): BackupPolicy = BackupPolicy(
        javaResource as
            com.pulumi.azurenative.dataprotection.BackupPolicy,
    )
}

/**
 * @see [BackupPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BackupPolicy].
 */
public suspend fun backupPolicy(
    name: String,
    block: suspend BackupPolicyResourceBuilder.() -> Unit,
): BackupPolicy {
    val builder = BackupPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BackupPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun backupPolicy(name: String): BackupPolicy {
    val builder = BackupPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
