@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin

import com.pulumi.azurenative.dataprotection.DataprotectionFunctions.getBackupInstancePlain
import com.pulumi.azurenative.dataprotection.DataprotectionFunctions.getBackupPolicyPlain
import com.pulumi.azurenative.dataprotection.DataprotectionFunctions.getBackupVaultPlain
import com.pulumi.azurenative.dataprotection.DataprotectionFunctions.getDppResourceGuardProxyPlain
import com.pulumi.azurenative.dataprotection.DataprotectionFunctions.getResourceGuardPlain
import com.pulumi.azurenative.dataprotection.kotlin.inputs.GetBackupInstancePlainArgs
import com.pulumi.azurenative.dataprotection.kotlin.inputs.GetBackupInstancePlainArgsBuilder
import com.pulumi.azurenative.dataprotection.kotlin.inputs.GetBackupPolicyPlainArgs
import com.pulumi.azurenative.dataprotection.kotlin.inputs.GetBackupPolicyPlainArgsBuilder
import com.pulumi.azurenative.dataprotection.kotlin.inputs.GetBackupVaultPlainArgs
import com.pulumi.azurenative.dataprotection.kotlin.inputs.GetBackupVaultPlainArgsBuilder
import com.pulumi.azurenative.dataprotection.kotlin.inputs.GetDppResourceGuardProxyPlainArgs
import com.pulumi.azurenative.dataprotection.kotlin.inputs.GetDppResourceGuardProxyPlainArgsBuilder
import com.pulumi.azurenative.dataprotection.kotlin.inputs.GetResourceGuardPlainArgs
import com.pulumi.azurenative.dataprotection.kotlin.inputs.GetResourceGuardPlainArgsBuilder
import com.pulumi.azurenative.dataprotection.kotlin.outputs.GetBackupInstanceResult
import com.pulumi.azurenative.dataprotection.kotlin.outputs.GetBackupPolicyResult
import com.pulumi.azurenative.dataprotection.kotlin.outputs.GetBackupVaultResult
import com.pulumi.azurenative.dataprotection.kotlin.outputs.GetDppResourceGuardProxyResult
import com.pulumi.azurenative.dataprotection.kotlin.outputs.GetResourceGuardResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.dataprotection.kotlin.outputs.GetBackupInstanceResult.Companion.toKotlin as getBackupInstanceResultToKotlin
import com.pulumi.azurenative.dataprotection.kotlin.outputs.GetBackupPolicyResult.Companion.toKotlin as getBackupPolicyResultToKotlin
import com.pulumi.azurenative.dataprotection.kotlin.outputs.GetBackupVaultResult.Companion.toKotlin as getBackupVaultResultToKotlin
import com.pulumi.azurenative.dataprotection.kotlin.outputs.GetDppResourceGuardProxyResult.Companion.toKotlin as getDppResourceGuardProxyResultToKotlin
import com.pulumi.azurenative.dataprotection.kotlin.outputs.GetResourceGuardResult.Companion.toKotlin as getResourceGuardResultToKotlin

public object DataprotectionFunctions {
    /**
     * Gets a backup instance with name in a backup vault
     * Azure REST API version: 2023-01-01.
     * Other available API versions: 2023-04-01-preview, 2023-05-01, 2023-06-01-preview, 2023-08-01, 2023-08-01-preview.
     * @param argument null
     * @return BackupInstance Resource
     */
    public suspend fun getBackupInstance(argument: GetBackupInstancePlainArgs):
        GetBackupInstanceResult =
        getBackupInstanceResultToKotlin(getBackupInstancePlain(argument.toJava()).await())

    /**
     * @see [getBackupInstance].
     * @param backupInstanceName The name of the backup instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vaultName The name of the backup vault.
     * @return BackupInstance Resource
     */
    public suspend fun getBackupInstance(
        backupInstanceName: String,
        resourceGroupName: String,
        vaultName: String,
    ): GetBackupInstanceResult {
        val argument = GetBackupInstancePlainArgs(
            backupInstanceName = backupInstanceName,
            resourceGroupName = resourceGroupName,
            vaultName = vaultName,
        )
        return getBackupInstanceResultToKotlin(getBackupInstancePlain(argument.toJava()).await())
    }

    /**
     * @see [getBackupInstance].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;dataprotection&#46;kotlin&#46;inputs&#46;GetBackupInstancePlainArgs].
     * @return BackupInstance Resource
     */
    public suspend
    fun getBackupInstance(argument: suspend GetBackupInstancePlainArgsBuilder.() -> Unit):
        GetBackupInstanceResult {
        val builder = GetBackupInstancePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBackupInstanceResultToKotlin(getBackupInstancePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a backup policy belonging to a backup vault
     * Azure REST API version: 2023-01-01.
     * Other available API versions: 2023-04-01-preview, 2023-05-01, 2023-06-01-preview, 2023-08-01, 2023-08-01-preview.
     * @param argument null
     * @return BaseBackupPolicy resource
     */
    public suspend fun getBackupPolicy(argument: GetBackupPolicyPlainArgs): GetBackupPolicyResult =
        getBackupPolicyResultToKotlin(getBackupPolicyPlain(argument.toJava()).await())

    /**
     * @see [getBackupPolicy].
     * @param backupPolicyName
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vaultName The name of the backup vault.
     * @return BaseBackupPolicy resource
     */
    public suspend fun getBackupPolicy(
        backupPolicyName: String,
        resourceGroupName: String,
        vaultName: String,
    ): GetBackupPolicyResult {
        val argument = GetBackupPolicyPlainArgs(
            backupPolicyName = backupPolicyName,
            resourceGroupName = resourceGroupName,
            vaultName = vaultName,
        )
        return getBackupPolicyResultToKotlin(getBackupPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getBackupPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;dataprotection&#46;kotlin&#46;inputs&#46;GetBackupPolicyPlainArgs].
     * @return BaseBackupPolicy resource
     */
    public suspend fun getBackupPolicy(argument: suspend GetBackupPolicyPlainArgsBuilder.() -> Unit):
        GetBackupPolicyResult {
        val builder = GetBackupPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBackupPolicyResultToKotlin(getBackupPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns a resource belonging to a resource group.
     * Azure REST API version: 2023-01-01.
     * Other available API versions: 2023-04-01-preview, 2023-05-01, 2023-06-01-preview, 2023-08-01, 2023-08-01-preview.
     * @param argument null
     * @return Backup Vault Resource
     */
    public suspend fun getBackupVault(argument: GetBackupVaultPlainArgs): GetBackupVaultResult =
        getBackupVaultResultToKotlin(getBackupVaultPlain(argument.toJava()).await())

    /**
     * @see [getBackupVault].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vaultName The name of the backup vault.
     * @return Backup Vault Resource
     */
    public suspend fun getBackupVault(resourceGroupName: String, vaultName: String):
        GetBackupVaultResult {
        val argument = GetBackupVaultPlainArgs(
            resourceGroupName = resourceGroupName,
            vaultName = vaultName,
        )
        return getBackupVaultResultToKotlin(getBackupVaultPlain(argument.toJava()).await())
    }

    /**
     * @see [getBackupVault].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;dataprotection&#46;kotlin&#46;inputs&#46;GetBackupVaultPlainArgs].
     * @return Backup Vault Resource
     */
    public suspend fun getBackupVault(argument: suspend GetBackupVaultPlainArgsBuilder.() -> Unit):
        GetBackupVaultResult {
        val builder = GetBackupVaultPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBackupVaultResultToKotlin(getBackupVaultPlain(builtArgument.toJava()).await())
    }

    /**
     * ResourceGuardProxyBaseResource object, used for response and request bodies for ResourceGuardProxy APIs
     * Azure REST API version: 2023-01-01.
     * Other available API versions: 2023-04-01-preview, 2023-05-01, 2023-06-01-preview, 2023-08-01, 2023-08-01-preview.
     * @param argument null
     * @return ResourceGuardProxyBaseResource object, used for response and request bodies for ResourceGuardProxy APIs
     */
    public suspend fun getDppResourceGuardProxy(argument: GetDppResourceGuardProxyPlainArgs):
        GetDppResourceGuardProxyResult =
        getDppResourceGuardProxyResultToKotlin(getDppResourceGuardProxyPlain(argument.toJava()).await())

    /**
     * @see [getDppResourceGuardProxy].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceGuardProxyName name of the resource guard proxy
     * @param vaultName The name of the backup vault.
     * @return ResourceGuardProxyBaseResource object, used for response and request bodies for ResourceGuardProxy APIs
     */
    public suspend fun getDppResourceGuardProxy(
        resourceGroupName: String,
        resourceGuardProxyName: String,
        vaultName: String,
    ): GetDppResourceGuardProxyResult {
        val argument = GetDppResourceGuardProxyPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceGuardProxyName = resourceGuardProxyName,
            vaultName = vaultName,
        )
        return getDppResourceGuardProxyResultToKotlin(getDppResourceGuardProxyPlain(argument.toJava()).await())
    }

    /**
     * @see [getDppResourceGuardProxy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;dataprotection&#46;kotlin&#46;inputs&#46;GetDppResourceGuardProxyPlainArgs].
     * @return ResourceGuardProxyBaseResource object, used for response and request bodies for ResourceGuardProxy APIs
     */
    public suspend
    fun getDppResourceGuardProxy(argument: suspend GetDppResourceGuardProxyPlainArgsBuilder.() -> Unit):
        GetDppResourceGuardProxyResult {
        val builder = GetDppResourceGuardProxyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDppResourceGuardProxyResultToKotlin(getDppResourceGuardProxyPlain(builtArgument.toJava()).await())
    }

    /**
     *
     * Azure REST API version: 2023-01-01.
     * Other available API versions: 2022-11-01-preview, 2023-04-01-preview, 2023-05-01, 2023-06-01-preview, 2023-08-01, 2023-08-01-preview.
     * @param argument null
     * @return null
     */
    public suspend fun getResourceGuard(argument: GetResourceGuardPlainArgs): GetResourceGuardResult =
        getResourceGuardResultToKotlin(getResourceGuardPlain(argument.toJava()).await())

    /**
     * @see [getResourceGuard].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceGuardsName The name of ResourceGuard
     * @return null
     */
    public suspend fun getResourceGuard(resourceGroupName: String, resourceGuardsName: String):
        GetResourceGuardResult {
        val argument = GetResourceGuardPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceGuardsName = resourceGuardsName,
        )
        return getResourceGuardResultToKotlin(getResourceGuardPlain(argument.toJava()).await())
    }

    /**
     * @see [getResourceGuard].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;dataprotection&#46;kotlin&#46;inputs&#46;GetResourceGuardPlainArgs].
     * @return null
     */
    public suspend
    fun getResourceGuard(argument: suspend GetResourceGuardPlainArgsBuilder.() -> Unit):
        GetResourceGuardResult {
        val builder = GetResourceGuardPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getResourceGuardResultToKotlin(getResourceGuardPlain(builtArgument.toJava()).await())
    }
}
