@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.AdhocBasedTaggingCriteriaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Adhoc backup tagging criteria
 * @property tagInfo Retention tag information
 */
public data class AdhocBasedTaggingCriteriaArgs(
    public val tagInfo: Output<RetentionTagArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.AdhocBasedTaggingCriteriaArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.inputs.AdhocBasedTaggingCriteriaArgs =
        com.pulumi.azurenative.dataprotection.inputs.AdhocBasedTaggingCriteriaArgs.builder()
            .tagInfo(tagInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AdhocBasedTaggingCriteriaArgs].
 */
@PulumiTagMarker
public class AdhocBasedTaggingCriteriaArgsBuilder internal constructor() {
    private var tagInfo: Output<RetentionTagArgs>? = null

    /**
     * @param value Retention tag information
     */
    @JvmName("embkqovvrqkfsupo")
    public suspend fun tagInfo(`value`: Output<RetentionTagArgs>) {
        this.tagInfo = value
    }

    /**
     * @param value Retention tag information
     */
    @JvmName("hfhxxrdvdppcditu")
    public suspend fun tagInfo(`value`: RetentionTagArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagInfo = mapped
    }

    /**
     * @param argument Retention tag information
     */
    @JvmName("nvsfqxnqfowactwr")
    public suspend fun tagInfo(argument: suspend RetentionTagArgsBuilder.() -> Unit) {
        val toBeMapped = RetentionTagArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tagInfo = mapped
    }

    internal fun build(): AdhocBasedTaggingCriteriaArgs = AdhocBasedTaggingCriteriaArgs(
        tagInfo = tagInfo,
    )
}
