@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.BackupInstanceArgs.builder
import com.pulumi.azurenative.dataprotection.kotlin.enums.ValidationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Backup Instance
 * @property dataSourceInfo Gets or sets the data source information.
 * @property dataSourceSetInfo Gets or sets the data source set information.
 * @property datasourceAuthCredentials Credentials to use to authenticate with data source provider.
 * @property friendlyName Gets or sets the Backup Instance friendly name.
 * @property objectType
 * @property policyInfo Gets or sets the policy information.
 * @property validationType Specifies the type of validation. In case of DeepValidation, all validations from /validateForBackup API will run again.
 */
public data class BackupInstanceArgs(
    public val dataSourceInfo: Output<DatasourceArgs>,
    public val dataSourceSetInfo: Output<DatasourceSetArgs>? = null,
    public val datasourceAuthCredentials: Output<SecretStoreBasedAuthCredentialsArgs>? = null,
    public val friendlyName: Output<String>? = null,
    public val objectType: Output<String>,
    public val policyInfo: Output<PolicyInfoArgs>,
    public val validationType: Output<Either<String, ValidationType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.BackupInstanceArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.inputs.BackupInstanceArgs =
        com.pulumi.azurenative.dataprotection.inputs.BackupInstanceArgs.builder()
            .dataSourceInfo(dataSourceInfo.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dataSourceSetInfo(dataSourceSetInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .datasourceAuthCredentials(
                datasourceAuthCredentials?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .friendlyName(friendlyName?.applyValue({ args0 -> args0 }))
            .objectType(objectType.applyValue({ args0 -> args0 }))
            .policyInfo(policyInfo.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .validationType(
                validationType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [BackupInstanceArgs].
 */
@PulumiTagMarker
public class BackupInstanceArgsBuilder internal constructor() {
    private var dataSourceInfo: Output<DatasourceArgs>? = null

    private var dataSourceSetInfo: Output<DatasourceSetArgs>? = null

    private var datasourceAuthCredentials: Output<SecretStoreBasedAuthCredentialsArgs>? = null

    private var friendlyName: Output<String>? = null

    private var objectType: Output<String>? = null

    private var policyInfo: Output<PolicyInfoArgs>? = null

    private var validationType: Output<Either<String, ValidationType>>? = null

    /**
     * @param value Gets or sets the data source information.
     */
    @JvmName("ctiggafmjkplnrvb")
    public suspend fun dataSourceInfo(`value`: Output<DatasourceArgs>) {
        this.dataSourceInfo = value
    }

    /**
     * @param value Gets or sets the data source set information.
     */
    @JvmName("bqrqhvyawssmpneh")
    public suspend fun dataSourceSetInfo(`value`: Output<DatasourceSetArgs>) {
        this.dataSourceSetInfo = value
    }

    /**
     * @param value Credentials to use to authenticate with data source provider.
     */
    @JvmName("tlitconepdpgrxdt")
    public suspend
    fun datasourceAuthCredentials(`value`: Output<SecretStoreBasedAuthCredentialsArgs>) {
        this.datasourceAuthCredentials = value
    }

    /**
     * @param value Gets or sets the Backup Instance friendly name.
     */
    @JvmName("mcmatfslmeuqwhtw")
    public suspend fun friendlyName(`value`: Output<String>) {
        this.friendlyName = value
    }

    /**
     * @param value
     */
    @JvmName("crtjrbtiuekjbkoe")
    public suspend fun objectType(`value`: Output<String>) {
        this.objectType = value
    }

    /**
     * @param value Gets or sets the policy information.
     */
    @JvmName("churihxrsouawjbu")
    public suspend fun policyInfo(`value`: Output<PolicyInfoArgs>) {
        this.policyInfo = value
    }

    /**
     * @param value Specifies the type of validation. In case of DeepValidation, all validations from /validateForBackup API will run again.
     */
    @JvmName("lbevgmdpymvcpqdl")
    public suspend fun validationType(`value`: Output<Either<String, ValidationType>>) {
        this.validationType = value
    }

    /**
     * @param value Gets or sets the data source information.
     */
    @JvmName("rxqmmhjtwvfxgahd")
    public suspend fun dataSourceInfo(`value`: DatasourceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataSourceInfo = mapped
    }

    /**
     * @param argument Gets or sets the data source information.
     */
    @JvmName("tovmngayxutuyrjv")
    public suspend fun dataSourceInfo(argument: suspend DatasourceArgsBuilder.() -> Unit) {
        val toBeMapped = DatasourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dataSourceInfo = mapped
    }

    /**
     * @param value Gets or sets the data source set information.
     */
    @JvmName("umsrmxtnfydqybxu")
    public suspend fun dataSourceSetInfo(`value`: DatasourceSetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSourceSetInfo = mapped
    }

    /**
     * @param argument Gets or sets the data source set information.
     */
    @JvmName("bhfbjluigidaayvd")
    public suspend fun dataSourceSetInfo(argument: suspend DatasourceSetArgsBuilder.() -> Unit) {
        val toBeMapped = DatasourceSetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dataSourceSetInfo = mapped
    }

    /**
     * @param value Credentials to use to authenticate with data source provider.
     */
    @JvmName("ibmvtymjsgvkqqge")
    public suspend fun datasourceAuthCredentials(`value`: SecretStoreBasedAuthCredentialsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datasourceAuthCredentials = mapped
    }

    /**
     * @param argument Credentials to use to authenticate with data source provider.
     */
    @JvmName("iechhjshdhvfojvs")
    public suspend
    fun datasourceAuthCredentials(argument: suspend SecretStoreBasedAuthCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = SecretStoreBasedAuthCredentialsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.datasourceAuthCredentials = mapped
    }

    /**
     * @param value Gets or sets the Backup Instance friendly name.
     */
    @JvmName("nfjqfuphcypnyxqd")
    public suspend fun friendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.friendlyName = mapped
    }

    /**
     * @param value
     */
    @JvmName("typoxkcacfobouvp")
    public suspend fun objectType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objectType = mapped
    }

    /**
     * @param value Gets or sets the policy information.
     */
    @JvmName("stbplkvkjfmpmtft")
    public suspend fun policyInfo(`value`: PolicyInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyInfo = mapped
    }

    /**
     * @param argument Gets or sets the policy information.
     */
    @JvmName("vhbqijfmjufvfkpc")
    public suspend fun policyInfo(argument: suspend PolicyInfoArgsBuilder.() -> Unit) {
        val toBeMapped = PolicyInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.policyInfo = mapped
    }

    /**
     * @param value Specifies the type of validation. In case of DeepValidation, all validations from /validateForBackup API will run again.
     */
    @JvmName("esgdhpbpgwllqhxu")
    public suspend fun validationType(`value`: Either<String, ValidationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationType = mapped
    }

    /**
     * @param value Specifies the type of validation. In case of DeepValidation, all validations from /validateForBackup API will run again.
     */
    @JvmName("okrovxjxkgwqcgrn")
    public fun validationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ValidationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.validationType = mapped
    }

    /**
     * @param value Specifies the type of validation. In case of DeepValidation, all validations from /validateForBackup API will run again.
     */
    @JvmName("smbjkefstsyobawi")
    public fun validationType(`value`: ValidationType) {
        val toBeMapped = Either.ofRight<String, ValidationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.validationType = mapped
    }

    internal fun build(): BackupInstanceArgs = BackupInstanceArgs(
        dataSourceInfo = dataSourceInfo ?: throw PulumiNullFieldException("dataSourceInfo"),
        dataSourceSetInfo = dataSourceSetInfo,
        datasourceAuthCredentials = datasourceAuthCredentials,
        friendlyName = friendlyName,
        objectType = objectType ?: throw PulumiNullFieldException("objectType"),
        policyInfo = policyInfo ?: throw PulumiNullFieldException("policyInfo"),
        validationType = validationType,
    )
}
