@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.BackupPolicyArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Rule based backup policy
 * @property datasourceTypes Type of datasource for the backup management
 * @property objectType
 * Expected value is 'BackupPolicy'.
 * @property policyRules Policy rule dictionary that contains rules for each backuptype i.e Full/Incremental/Logs etc
 */
public data class BackupPolicyArgs(
    public val datasourceTypes: Output<List<String>>,
    public val objectType: Output<String>,
    public val policyRules: Output<List<Either<AzureBackupRuleArgs, AzureRetentionRuleArgs>>>,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.BackupPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.inputs.BackupPolicyArgs =
        com.pulumi.azurenative.dataprotection.inputs.BackupPolicyArgs.builder()
            .datasourceTypes(datasourceTypes.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .objectType(objectType.applyValue({ args0 -> args0 }))
            .policyRules(
                policyRules.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0.let({ args0 -> args0.toJava() })
                        }, { args0 ->
                            args0.let({ args0 ->
                                args0.toJava()
                            })
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [BackupPolicyArgs].
 */
@PulumiTagMarker
public class BackupPolicyArgsBuilder internal constructor() {
    private var datasourceTypes: Output<List<String>>? = null

    private var objectType: Output<String>? = null

    private var policyRules: Output<List<Either<AzureBackupRuleArgs, AzureRetentionRuleArgs>>>? = null

    /**
     * @param value Type of datasource for the backup management
     */
    @JvmName("ohwjjjuocksalxqn")
    public suspend fun datasourceTypes(`value`: Output<List<String>>) {
        this.datasourceTypes = value
    }

    @JvmName("kyccwjwcxsolsdsa")
    public suspend fun datasourceTypes(vararg values: Output<String>) {
        this.datasourceTypes = Output.all(values.asList())
    }

    /**
     * @param values Type of datasource for the backup management
     */
    @JvmName("ncnenqncngdiuocn")
    public suspend fun datasourceTypes(values: List<Output<String>>) {
        this.datasourceTypes = Output.all(values)
    }

    /**
     * @param value
     * Expected value is 'BackupPolicy'.
     */
    @JvmName("eqrxnmohlonulrgd")
    public suspend fun objectType(`value`: Output<String>) {
        this.objectType = value
    }

    /**
     * @param value Policy rule dictionary that contains rules for each backuptype i.e Full/Incremental/Logs etc
     */
    @JvmName("murxufoksyxfxesa")
    public suspend
    fun policyRules(`value`: Output<List<Either<AzureBackupRuleArgs, AzureRetentionRuleArgs>>>) {
        this.policyRules = value
    }

    @JvmName("jxoweanxjnjvuvao")
    public suspend fun policyRules(
        vararg
        values: Output<Either<AzureBackupRuleArgs, AzureRetentionRuleArgs>>,
    ) {
        this.policyRules = Output.all(values.asList())
    }

    /**
     * @param values Policy rule dictionary that contains rules for each backuptype i.e Full/Incremental/Logs etc
     */
    @JvmName("xgyywwbspdsmidqk")
    public suspend
    fun policyRules(values: List<Output<Either<AzureBackupRuleArgs, AzureRetentionRuleArgs>>>) {
        this.policyRules = Output.all(values)
    }

    /**
     * @param value Type of datasource for the backup management
     */
    @JvmName("sqhrnvarhrgftlrr")
    public suspend fun datasourceTypes(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.datasourceTypes = mapped
    }

    /**
     * @param values Type of datasource for the backup management
     */
    @JvmName("chlbhinwqrscmwgt")
    public suspend fun datasourceTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.datasourceTypes = mapped
    }

    /**
     * @param value
     * Expected value is 'BackupPolicy'.
     */
    @JvmName("cgjdfjvlrtdusrbl")
    public suspend fun objectType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objectType = mapped
    }

    /**
     * @param value Policy rule dictionary that contains rules for each backuptype i.e Full/Incremental/Logs etc
     */
    @JvmName("chmhpkmivhrwuism")
    public suspend
    fun policyRules(`value`: List<Either<AzureBackupRuleArgs, AzureRetentionRuleArgs>>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyRules = mapped
    }

    /**
     * @param values Policy rule dictionary that contains rules for each backuptype i.e Full/Incremental/Logs etc
     */
    @JvmName("wkaccaewcwlamrhm")
    public suspend fun policyRules(
        vararg
        values: Either<AzureBackupRuleArgs, AzureRetentionRuleArgs>,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyRules = mapped
    }

    internal fun build(): BackupPolicyArgs = BackupPolicyArgs(
        datasourceTypes = datasourceTypes ?: throw PulumiNullFieldException("datasourceTypes"),
        objectType = objectType ?: throw PulumiNullFieldException("objectType"),
        policyRules = policyRules ?: throw PulumiNullFieldException("policyRules"),
    )
}
