@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.DatasourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Datasource to be backed up
 * @property datasourceType DatasourceType of the resource.
 * @property objectType Type of Datasource object, used to initialize the right inherited type
 * @property resourceID Full ARM ID of the resource. For azure resources, this is ARM ID. For non azure resources, this will be the ID created by backup service via Fabric/Vault.
 * @property resourceLocation Location of datasource.
 * @property resourceName Unique identifier of the resource in the context of parent.
 * @property resourceType Resource Type of Datasource.
 * @property resourceUri Uri of the resource.
 */
public data class DatasourceArgs(
    public val datasourceType: Output<String>? = null,
    public val objectType: Output<String>? = null,
    public val resourceID: Output<String>,
    public val resourceLocation: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val resourceType: Output<String>? = null,
    public val resourceUri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.DatasourceArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.inputs.DatasourceArgs =
        com.pulumi.azurenative.dataprotection.inputs.DatasourceArgs.builder()
            .datasourceType(datasourceType?.applyValue({ args0 -> args0 }))
            .objectType(objectType?.applyValue({ args0 -> args0 }))
            .resourceID(resourceID.applyValue({ args0 -> args0 }))
            .resourceLocation(resourceLocation?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .resourceType(resourceType?.applyValue({ args0 -> args0 }))
            .resourceUri(resourceUri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DatasourceArgs].
 */
@PulumiTagMarker
public class DatasourceArgsBuilder internal constructor() {
    private var datasourceType: Output<String>? = null

    private var objectType: Output<String>? = null

    private var resourceID: Output<String>? = null

    private var resourceLocation: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var resourceType: Output<String>? = null

    private var resourceUri: Output<String>? = null

    /**
     * @param value DatasourceType of the resource.
     */
    @JvmName("ujhyahnbisksdrbr")
    public suspend fun datasourceType(`value`: Output<String>) {
        this.datasourceType = value
    }

    /**
     * @param value Type of Datasource object, used to initialize the right inherited type
     */
    @JvmName("kwvhpqhflfsisaej")
    public suspend fun objectType(`value`: Output<String>) {
        this.objectType = value
    }

    /**
     * @param value Full ARM ID of the resource. For azure resources, this is ARM ID. For non azure resources, this will be the ID created by backup service via Fabric/Vault.
     */
    @JvmName("tcligxysifuhdfay")
    public suspend fun resourceID(`value`: Output<String>) {
        this.resourceID = value
    }

    /**
     * @param value Location of datasource.
     */
    @JvmName("vkoucmmymywflrqr")
    public suspend fun resourceLocation(`value`: Output<String>) {
        this.resourceLocation = value
    }

    /**
     * @param value Unique identifier of the resource in the context of parent.
     */
    @JvmName("wmwtkbtqrejcxech")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Resource Type of Datasource.
     */
    @JvmName("jraysqfgxxcvhxmg")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value Uri of the resource.
     */
    @JvmName("iomhcspgvsyyybal")
    public suspend fun resourceUri(`value`: Output<String>) {
        this.resourceUri = value
    }

    /**
     * @param value DatasourceType of the resource.
     */
    @JvmName("ibyqasfvscfxheuj")
    public suspend fun datasourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datasourceType = mapped
    }

    /**
     * @param value Type of Datasource object, used to initialize the right inherited type
     */
    @JvmName("lukrxevpeybyjepp")
    public suspend fun objectType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectType = mapped
    }

    /**
     * @param value Full ARM ID of the resource. For azure resources, this is ARM ID. For non azure resources, this will be the ID created by backup service via Fabric/Vault.
     */
    @JvmName("etbqxpklqgwkpalm")
    public suspend fun resourceID(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceID = mapped
    }

    /**
     * @param value Location of datasource.
     */
    @JvmName("nqdvaptpblexvajt")
    public suspend fun resourceLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceLocation = mapped
    }

    /**
     * @param value Unique identifier of the resource in the context of parent.
     */
    @JvmName("evtbnamvchmlqcad")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value Resource Type of Datasource.
     */
    @JvmName("uriymvljrtopglhp")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value Uri of the resource.
     */
    @JvmName("buiwcsviiwqcufxm")
    public suspend fun resourceUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceUri = mapped
    }

    internal fun build(): DatasourceArgs = DatasourceArgs(
        datasourceType = datasourceType,
        objectType = objectType,
        resourceID = resourceID ?: throw PulumiNullFieldException("resourceID"),
        resourceLocation = resourceLocation,
        resourceName = resourceName,
        resourceType = resourceType,
        resourceUri = resourceUri,
    )
}
