@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.DppIdentityDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Identity details
 * @property type The identityType which can be either SystemAssigned or None
 */
public data class DppIdentityDetailsArgs(
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.DppIdentityDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.inputs.DppIdentityDetailsArgs =
        com.pulumi.azurenative.dataprotection.inputs.DppIdentityDetailsArgs.builder()
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DppIdentityDetailsArgs].
 */
@PulumiTagMarker
public class DppIdentityDetailsArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    /**
     * @param value The identityType which can be either SystemAssigned or None
     */
    @JvmName("jswurltcuwhabqdr")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The identityType which can be either SystemAssigned or None
     */
    @JvmName("xhsmyxkwneeqelvs")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): DppIdentityDetailsArgs = DppIdentityDetailsArgs(
        type = type,
    )
}
