@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.KubernetesClusterBackupDatasourceParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Parameters for Kubernetes Cluster Backup Datasource
 * @property excludedNamespaces Gets or sets the exclude namespaces property. This property sets the namespaces to be excluded during restore.
 * @property excludedResourceTypes Gets or sets the exclude resource types property. This property sets the resource types to be excluded during restore.
 * @property includeClusterScopeResources Gets or sets the include cluster resources property. This property if enabled will include cluster scope resources during restore.
 * @property includedNamespaces Gets or sets the include namespaces property. This property sets the namespaces to be included during restore.
 * @property includedResourceTypes Gets or sets the include resource types property. This property sets the resource types to be included during restore.
 * @property labelSelectors Gets or sets the LabelSelectors property. This property sets the resource with such label selectors to be included during restore.
 * @property objectType Type of the specific object - used for deserializing
 * Expected value is 'KubernetesClusterBackupDatasourceParameters'.
 * @property snapshotVolumes Gets or sets the volume snapshot property. This property if enabled will take volume snapshots during restore.
 */
public data class KubernetesClusterBackupDatasourceParametersArgs(
    public val excludedNamespaces: Output<List<String>>? = null,
    public val excludedResourceTypes: Output<List<String>>? = null,
    public val includeClusterScopeResources: Output<Boolean>,
    public val includedNamespaces: Output<List<String>>? = null,
    public val includedResourceTypes: Output<List<String>>? = null,
    public val labelSelectors: Output<List<String>>? = null,
    public val objectType: Output<String>,
    public val snapshotVolumes: Output<Boolean>,
) :
    ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.KubernetesClusterBackupDatasourceParametersArgs> {
    override fun toJava():
        com.pulumi.azurenative.dataprotection.inputs.KubernetesClusterBackupDatasourceParametersArgs =
        com.pulumi.azurenative.dataprotection.inputs.KubernetesClusterBackupDatasourceParametersArgs.builder()
            .excludedNamespaces(excludedNamespaces?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .excludedResourceTypes(excludedResourceTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .includeClusterScopeResources(includeClusterScopeResources.applyValue({ args0 -> args0 }))
            .includedNamespaces(includedNamespaces?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .includedResourceTypes(includedResourceTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .labelSelectors(labelSelectors?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .objectType(objectType.applyValue({ args0 -> args0 }))
            .snapshotVolumes(snapshotVolumes.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KubernetesClusterBackupDatasourceParametersArgs].
 */
@PulumiTagMarker
public class KubernetesClusterBackupDatasourceParametersArgsBuilder internal constructor() {
    private var excludedNamespaces: Output<List<String>>? = null

    private var excludedResourceTypes: Output<List<String>>? = null

    private var includeClusterScopeResources: Output<Boolean>? = null

    private var includedNamespaces: Output<List<String>>? = null

    private var includedResourceTypes: Output<List<String>>? = null

    private var labelSelectors: Output<List<String>>? = null

    private var objectType: Output<String>? = null

    private var snapshotVolumes: Output<Boolean>? = null

    /**
     * @param value Gets or sets the exclude namespaces property. This property sets the namespaces to be excluded during restore.
     */
    @JvmName("jgqseofabgugfcsm")
    public suspend fun excludedNamespaces(`value`: Output<List<String>>) {
        this.excludedNamespaces = value
    }

    @JvmName("lqvracpgqkwfgabh")
    public suspend fun excludedNamespaces(vararg values: Output<String>) {
        this.excludedNamespaces = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the exclude namespaces property. This property sets the namespaces to be excluded during restore.
     */
    @JvmName("auhfyansusvahgha")
    public suspend fun excludedNamespaces(values: List<Output<String>>) {
        this.excludedNamespaces = Output.all(values)
    }

    /**
     * @param value Gets or sets the exclude resource types property. This property sets the resource types to be excluded during restore.
     */
    @JvmName("tbtwclgngkpgjylq")
    public suspend fun excludedResourceTypes(`value`: Output<List<String>>) {
        this.excludedResourceTypes = value
    }

    @JvmName("kfttcivybyikrloe")
    public suspend fun excludedResourceTypes(vararg values: Output<String>) {
        this.excludedResourceTypes = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the exclude resource types property. This property sets the resource types to be excluded during restore.
     */
    @JvmName("toeklbujntkmbfav")
    public suspend fun excludedResourceTypes(values: List<Output<String>>) {
        this.excludedResourceTypes = Output.all(values)
    }

    /**
     * @param value Gets or sets the include cluster resources property. This property if enabled will include cluster scope resources during restore.
     */
    @JvmName("ewyuwclhvcmbxkpn")
    public suspend fun includeClusterScopeResources(`value`: Output<Boolean>) {
        this.includeClusterScopeResources = value
    }

    /**
     * @param value Gets or sets the include namespaces property. This property sets the namespaces to be included during restore.
     */
    @JvmName("egbpnjpfgjbnevxs")
    public suspend fun includedNamespaces(`value`: Output<List<String>>) {
        this.includedNamespaces = value
    }

    @JvmName("shsacavbvkbbjedx")
    public suspend fun includedNamespaces(vararg values: Output<String>) {
        this.includedNamespaces = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the include namespaces property. This property sets the namespaces to be included during restore.
     */
    @JvmName("ujeqyicmtaefelud")
    public suspend fun includedNamespaces(values: List<Output<String>>) {
        this.includedNamespaces = Output.all(values)
    }

    /**
     * @param value Gets or sets the include resource types property. This property sets the resource types to be included during restore.
     */
    @JvmName("xclcjohswbvgftro")
    public suspend fun includedResourceTypes(`value`: Output<List<String>>) {
        this.includedResourceTypes = value
    }

    @JvmName("ynsjslqtpltxhfne")
    public suspend fun includedResourceTypes(vararg values: Output<String>) {
        this.includedResourceTypes = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the include resource types property. This property sets the resource types to be included during restore.
     */
    @JvmName("rcggshmhaykfkwua")
    public suspend fun includedResourceTypes(values: List<Output<String>>) {
        this.includedResourceTypes = Output.all(values)
    }

    /**
     * @param value Gets or sets the LabelSelectors property. This property sets the resource with such label selectors to be included during restore.
     */
    @JvmName("qgexlitpbkqnqwmf")
    public suspend fun labelSelectors(`value`: Output<List<String>>) {
        this.labelSelectors = value
    }

    @JvmName("dsuaqasacsxuwlev")
    public suspend fun labelSelectors(vararg values: Output<String>) {
        this.labelSelectors = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the LabelSelectors property. This property sets the resource with such label selectors to be included during restore.
     */
    @JvmName("unvvhcwsjecsiujq")
    public suspend fun labelSelectors(values: List<Output<String>>) {
        this.labelSelectors = Output.all(values)
    }

    /**
     * @param value Type of the specific object - used for deserializing
     * Expected value is 'KubernetesClusterBackupDatasourceParameters'.
     */
    @JvmName("loidogreybxlnlna")
    public suspend fun objectType(`value`: Output<String>) {
        this.objectType = value
    }

    /**
     * @param value Gets or sets the volume snapshot property. This property if enabled will take volume snapshots during restore.
     */
    @JvmName("pydwkqixffbmnwbk")
    public suspend fun snapshotVolumes(`value`: Output<Boolean>) {
        this.snapshotVolumes = value
    }

    /**
     * @param value Gets or sets the exclude namespaces property. This property sets the namespaces to be excluded during restore.
     */
    @JvmName("rhunxxqdrfqwtbvy")
    public suspend fun excludedNamespaces(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludedNamespaces = mapped
    }

    /**
     * @param values Gets or sets the exclude namespaces property. This property sets the namespaces to be excluded during restore.
     */
    @JvmName("inqlkhtewnmqwiie")
    public suspend fun excludedNamespaces(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludedNamespaces = mapped
    }

    /**
     * @param value Gets or sets the exclude resource types property. This property sets the resource types to be excluded during restore.
     */
    @JvmName("agjicvflhuleegru")
    public suspend fun excludedResourceTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludedResourceTypes = mapped
    }

    /**
     * @param values Gets or sets the exclude resource types property. This property sets the resource types to be excluded during restore.
     */
    @JvmName("dgjwainmiwrkmfuc")
    public suspend fun excludedResourceTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludedResourceTypes = mapped
    }

    /**
     * @param value Gets or sets the include cluster resources property. This property if enabled will include cluster scope resources during restore.
     */
    @JvmName("neculkmcwtawipks")
    public suspend fun includeClusterScopeResources(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.includeClusterScopeResources = mapped
    }

    /**
     * @param value Gets or sets the include namespaces property. This property sets the namespaces to be included during restore.
     */
    @JvmName("idpfwjimtrgmhfej")
    public suspend fun includedNamespaces(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includedNamespaces = mapped
    }

    /**
     * @param values Gets or sets the include namespaces property. This property sets the namespaces to be included during restore.
     */
    @JvmName("gnmtrnfnltbqcpwe")
    public suspend fun includedNamespaces(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.includedNamespaces = mapped
    }

    /**
     * @param value Gets or sets the include resource types property. This property sets the resource types to be included during restore.
     */
    @JvmName("bftfuxhbflmpgrdu")
    public suspend fun includedResourceTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includedResourceTypes = mapped
    }

    /**
     * @param values Gets or sets the include resource types property. This property sets the resource types to be included during restore.
     */
    @JvmName("agwsvvkywoidulwv")
    public suspend fun includedResourceTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.includedResourceTypes = mapped
    }

    /**
     * @param value Gets or sets the LabelSelectors property. This property sets the resource with such label selectors to be included during restore.
     */
    @JvmName("lskjhbmjrcmdesir")
    public suspend fun labelSelectors(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labelSelectors = mapped
    }

    /**
     * @param values Gets or sets the LabelSelectors property. This property sets the resource with such label selectors to be included during restore.
     */
    @JvmName("stojncmnetrqwvwf")
    public suspend fun labelSelectors(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labelSelectors = mapped
    }

    /**
     * @param value Type of the specific object - used for deserializing
     * Expected value is 'KubernetesClusterBackupDatasourceParameters'.
     */
    @JvmName("qaxjjqhptefrsnbk")
    public suspend fun objectType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objectType = mapped
    }

    /**
     * @param value Gets or sets the volume snapshot property. This property if enabled will take volume snapshots during restore.
     */
    @JvmName("migcqgucchenicyl")
    public suspend fun snapshotVolumes(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.snapshotVolumes = mapped
    }

    internal fun build(): KubernetesClusterBackupDatasourceParametersArgs =
        KubernetesClusterBackupDatasourceParametersArgs(
            excludedNamespaces = excludedNamespaces,
            excludedResourceTypes = excludedResourceTypes,
            includeClusterScopeResources = includeClusterScopeResources ?: throw
                PulumiNullFieldException("includeClusterScopeResources"),
            includedNamespaces = includedNamespaces,
            includedResourceTypes = includedResourceTypes,
            labelSelectors = labelSelectors,
            objectType = objectType ?: throw PulumiNullFieldException("objectType"),
            snapshotVolumes = snapshotVolumes ?: throw PulumiNullFieldException("snapshotVolumes"),
        )
}
