@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.MonitoringSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Monitoring Settings
 * @property azureMonitorAlertSettings Settings for Azure Monitor based alerts
 */
public data class MonitoringSettingsArgs(
    public val azureMonitorAlertSettings: Output<AzureMonitorAlertSettingsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.MonitoringSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.inputs.MonitoringSettingsArgs =
        com.pulumi.azurenative.dataprotection.inputs.MonitoringSettingsArgs.builder()
            .azureMonitorAlertSettings(
                azureMonitorAlertSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [MonitoringSettingsArgs].
 */
@PulumiTagMarker
public class MonitoringSettingsArgsBuilder internal constructor() {
    private var azureMonitorAlertSettings: Output<AzureMonitorAlertSettingsArgs>? = null

    /**
     * @param value Settings for Azure Monitor based alerts
     */
    @JvmName("glxewbigfbnxigtn")
    public suspend fun azureMonitorAlertSettings(`value`: Output<AzureMonitorAlertSettingsArgs>) {
        this.azureMonitorAlertSettings = value
    }

    /**
     * @param value Settings for Azure Monitor based alerts
     */
    @JvmName("csjdtshxhpqqvnik")
    public suspend fun azureMonitorAlertSettings(`value`: AzureMonitorAlertSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureMonitorAlertSettings = mapped
    }

    /**
     * @param argument Settings for Azure Monitor based alerts
     */
    @JvmName("vvijtjqjbqqfxivp")
    public suspend
    fun azureMonitorAlertSettings(argument: suspend AzureMonitorAlertSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = AzureMonitorAlertSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.azureMonitorAlertSettings = mapped
    }

    internal fun build(): MonitoringSettingsArgs = MonitoringSettingsArgs(
        azureMonitorAlertSettings = azureMonitorAlertSettings,
    )
}
