@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.RetentionTagArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Retention tag
 * @property tagName Retention Tag Name to relate it to retention rule.
 */
public data class RetentionTagArgs(
    public val tagName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.RetentionTagArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.inputs.RetentionTagArgs =
        com.pulumi.azurenative.dataprotection.inputs.RetentionTagArgs.builder()
            .tagName(tagName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RetentionTagArgs].
 */
@PulumiTagMarker
public class RetentionTagArgsBuilder internal constructor() {
    private var tagName: Output<String>? = null

    /**
     * @param value Retention Tag Name to relate it to retention rule.
     */
    @JvmName("obhajxpegchgelff")
    public suspend fun tagName(`value`: Output<String>) {
        this.tagName = value
    }

    /**
     * @param value Retention Tag Name to relate it to retention rule.
     */
    @JvmName("tlcbfjwqlslduhub")
    public suspend fun tagName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tagName = mapped
    }

    internal fun build(): RetentionTagArgs = RetentionTagArgs(
        tagName = tagName ?: throw PulumiNullFieldException("tagName"),
    )
}
