@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Parameters for Operational-Tier DataStore
 * @property dataStoreType type of datastore; Operational/Vault/Archive
 * @property objectType Type of the specific object - used for deserializing
 * Expected value is 'AzureOperationalStoreParameters'.
 * @property resourceGroupId Gets or sets the Snapshot Resource Group Uri.
 */
public data class AzureOperationalStoreParametersResponse(
    public val dataStoreType: String,
    public val objectType: String,
    public val resourceGroupId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.AzureOperationalStoreParametersResponse):
            AzureOperationalStoreParametersResponse = AzureOperationalStoreParametersResponse(
            dataStoreType = javaType.dataStoreType(),
            objectType = javaType.objectType(),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
