@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Identity details
 * @property principalId The object ID of the service principal object for the managed identity that is used to grant role-based access to an Azure resource.
 * @property tenantId A Globally Unique Identifier (GUID) that represents the Azure AD tenant where the resource is now a member.
 * @property type The identityType which can be either SystemAssigned or None
 */
public data class DppIdentityDetailsResponse(
    public val principalId: String,
    public val tenantId: String,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.DppIdentityDetailsResponse):
            DppIdentityDetailsResponse = DppIdentityDetailsResponse(
            principalId = javaType.principalId(),
            tenantId = javaType.tenantId(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
