@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Immediate copy Option
 * @property objectType Type of the specific object - used for deserializing
 * Expected value is 'ImmediateCopyOption'.
 */
public data class ImmediateCopyOptionResponse(
    public val objectType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.ImmediateCopyOptionResponse):
            ImmediateCopyOptionResponse = ImmediateCopyOptionResponse(
            objectType = javaType.objectType(),
        )
    }
}
