@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Source LifeCycle
 * @property deleteAfter Delete Option
 * @property sourceDataStore DataStoreInfo base
 * @property targetDataStoreCopySettings
 */
public data class SourceLifeCycleResponse(
    public val deleteAfter: AbsoluteDeleteOptionResponse,
    public val sourceDataStore: DataStoreInfoBaseResponse,
    public val targetDataStoreCopySettings: List<TargetCopySettingResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.SourceLifeCycleResponse):
            SourceLifeCycleResponse = SourceLifeCycleResponse(
            deleteAfter = javaType.deleteAfter().let({ args0 ->
                com.pulumi.azurenative.dataprotection.kotlin.outputs.AbsoluteDeleteOptionResponse.Companion.toKotlin(args0)
            }),
            sourceDataStore = javaType.sourceDataStore().let({ args0 ->
                com.pulumi.azurenative.dataprotection.kotlin.outputs.DataStoreInfoBaseResponse.Companion.toKotlin(args0)
            }),
            targetDataStoreCopySettings = javaType.targetDataStoreCopySettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dataprotection.kotlin.outputs.TargetCopySettingResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
