@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Storage setting
 * @property datastoreType Gets or sets the type of the datastore.
 * @property type Gets or sets the type.
 */
public data class StorageSettingResponse(
    public val datastoreType: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.StorageSettingResponse):
            StorageSettingResponse = StorageSettingResponse(
            datastoreType = javaType.datastoreType().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
