@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin

import com.pulumi.azurenative.datareplication.FabricArgs.builder
import com.pulumi.azurenative.datareplication.kotlin.inputs.FabricModelPropertiesArgs
import com.pulumi.azurenative.datareplication.kotlin.inputs.FabricModelPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Fabric model.
 * Azure REST API version: 2021-02-16-preview.
 * ## Example Usage
 * ### Fabric_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fabric = new AzureNative.DataReplication.Fabric("fabric", new()
 *     {
 *         FabricName = "wPR",
 *         Location = "tqygutlpob",
 *         Properties = new AzureNative.DataReplication.Inputs.FabricModelPropertiesArgs
 *         {
 *             CustomProperties =
 *             {
 *                 { "instanceType", "FabricModelCustomProperties" },
 *             },
 *         },
 *         ResourceGroupName = "rgrecoveryservicesdatareplication",
 *         Tags =
 *         {
 *             { "key3917", "vgralu" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datareplication/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := datareplication.NewFabric(ctx, "fabric", &datareplication.FabricArgs{
 * FabricName: pulumi.String("wPR"),
 * Location: pulumi.String("tqygutlpob"),
 * Properties: datareplication.FabricModelPropertiesResponse{
 * CustomProperties: interface{}{
 * InstanceType: pulumi.String("FabricModelCustomProperties"),
 * },
 * },
 * ResourceGroupName: pulumi.String("rgrecoveryservicesdatareplication"),
 * Tags: pulumi.StringMap{
 * "key3917": pulumi.String("vgralu"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datareplication.Fabric;
 * import com.pulumi.azurenative.datareplication.FabricArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fabric = new Fabric("fabric", FabricArgs.builder()
 *             .fabricName("wPR")
 *             .location("tqygutlpob")
 *             .properties(Map.of("customProperties", Map.of("instanceType", "FabricModelCustomProperties")))
 *             .resourceGroupName("rgrecoveryservicesdatareplication")
 *             .tags(Map.of("key3917", "vgralu"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datareplication:Fabric rhojydcwjgvgexpdwswjib /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationFabrics/{fabricName}
 * ```
 * @property fabricName The fabric name.
 * @property location Gets or sets the location of the fabric.
 * @property properties Fabric model properties.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Gets or sets the resource tags.
 */
public data class FabricArgs(
    public val fabricName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<FabricModelPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datareplication.FabricArgs> {
    override fun toJava(): com.pulumi.azurenative.datareplication.FabricArgs =
        com.pulumi.azurenative.datareplication.FabricArgs.builder()
            .fabricName(fabricName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [FabricArgs].
 */
@PulumiTagMarker
public class FabricArgsBuilder internal constructor() {
    private var fabricName: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<FabricModelPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The fabric name.
     */
    @JvmName("lrsscbjnxivqrcbs")
    public suspend fun fabricName(`value`: Output<String>) {
        this.fabricName = value
    }

    /**
     * @param value Gets or sets the location of the fabric.
     */
    @JvmName("mupoyamtalgjrxyq")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Fabric model properties.
     */
    @JvmName("cpuaxcsadqqkuxxd")
    public suspend fun properties(`value`: Output<FabricModelPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vvwpvjbgqawxvpcj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets or sets the resource tags.
     */
    @JvmName("vkfrncurbwjnmvic")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The fabric name.
     */
    @JvmName("jwlxqtquwyqljoto")
    public suspend fun fabricName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fabricName = mapped
    }

    /**
     * @param value Gets or sets the location of the fabric.
     */
    @JvmName("ptruhbrqlftgehwt")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Fabric model properties.
     */
    @JvmName("qcevcitmhuuejmwf")
    public suspend fun properties(`value`: FabricModelPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Fabric model properties.
     */
    @JvmName("ulgwvwbipjrwbkpu")
    public suspend fun properties(argument: suspend FabricModelPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = FabricModelPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("eoyknmethlwucdko")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Gets or sets the resource tags.
     */
    @JvmName("xmmjewtlhfkyxeka")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Gets or sets the resource tags.
     */
    @JvmName("vhpmbetqjidjuvcv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): FabricArgs = FabricArgs(
        fabricName = fabricName,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
