@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin

import com.pulumi.azurenative.datareplication.kotlin.outputs.PolicyModelPropertiesResponse
import com.pulumi.azurenative.datareplication.kotlin.outputs.PolicyModelResponseSystemData
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.datareplication.kotlin.outputs.PolicyModelPropertiesResponse.Companion.toKotlin as policyModelPropertiesResponseToKotlin
import com.pulumi.azurenative.datareplication.kotlin.outputs.PolicyModelResponseSystemData.Companion.toKotlin as policyModelResponseSystemDataToKotlin

/**
 * Builder for [Policy].
 */
@PulumiTagMarker
public class PolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PolicyArgs = PolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PolicyArgsBuilder.() -> Unit) {
        val builder = PolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Policy {
        val builtJavaResource = com.pulumi.azurenative.datareplication.Policy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Policy(builtJavaResource)
    }
}

/**
 * Policy model.
 * Azure REST API version: 2021-02-16-preview.
 * ## Example Usage
 * ### Policy_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policy = new AzureNative.DataReplication.Policy("policy", new()
 *     {
 *         PolicyName = "fafqwc",
 *         Properties = new AzureNative.DataReplication.Inputs.PolicyModelPropertiesArgs
 *         {
 *             CustomProperties =
 *             {
 *                 { "instanceType", "PolicyModelCustomProperties" },
 *             },
 *         },
 *         ResourceGroupName = "rgrecoveryservicesdatareplication",
 *         VaultName = "4",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datareplication/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := datareplication.NewPolicy(ctx, "policy", &datareplication.PolicyArgs{
 * PolicyName: pulumi.String("fafqwc"),
 * Properties: interface{}{
 * CustomProperties: interface{}{
 * InstanceType: pulumi.String("PolicyModelCustomProperties"),
 * },
 * },
 * ResourceGroupName: pulumi.String("rgrecoveryservicesdatareplication"),
 * VaultName: pulumi.String("4"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datareplication.Policy;
 * import com.pulumi.azurenative.datareplication.PolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policy = new Policy("policy", PolicyArgs.builder()
 *             .policyName("fafqwc")
 *             .properties(Map.of("customProperties", Map.of("instanceType", "PolicyModelCustomProperties")))
 *             .resourceGroupName("rgrecoveryservicesdatareplication")
 *             .vaultName("4")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datareplication:Policy ocmty /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationVaults/{vaultName}/replicationPolicies/{policyName}
 * ```
 */
public class Policy internal constructor(
    override val javaResource: com.pulumi.azurenative.datareplication.Policy,
) : KotlinCustomResource(javaResource, PolicyMapper) {
    /**
     * Gets or sets the name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Policy model properties.
     */
    public val properties: Output<PolicyModelPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                policyModelPropertiesResponseToKotlin(args0)
            })
        })

    public val systemData: Output<PolicyModelResponseSystemData>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                policyModelResponseSystemDataToKotlin(args0)
            })
        })

    /**
     * Gets or sets the type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PolicyMapper : ResourceMapper<Policy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datareplication.Policy::class == javaResource::class

    override fun map(javaResource: Resource): Policy = Policy(
        javaResource as
            com.pulumi.azurenative.datareplication.Policy,
    )
}

/**
 * @see [Policy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Policy].
 */
public suspend fun policy(name: String, block: suspend PolicyResourceBuilder.() -> Unit): Policy {
    val builder = PolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Policy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun policy(name: String): Policy {
    val builder = PolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
