@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.inputs

import com.pulumi.azurenative.datareplication.inputs.AzStackHCIFabricModelCustomPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * AzStackHCI fabric model custom properties.
 * @property azStackHciSiteId Gets or sets the ARM Id of the AzStackHCI site.
 * @property cluster AzStackHCI cluster properties.
 * @property instanceType Gets or sets the instance type.
 * Expected value is 'AzStackHCI'.
 * @property migrationSolutionId Gets or sets the Migration solution ARM Id.
 */
public data class AzStackHCIFabricModelCustomPropertiesArgs(
    public val azStackHciSiteId: Output<String>,
    public val cluster: Output<AzStackHCIClusterPropertiesArgs>,
    public val instanceType: Output<String>,
    public val migrationSolutionId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datareplication.inputs.AzStackHCIFabricModelCustomPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.datareplication.inputs.AzStackHCIFabricModelCustomPropertiesArgs =
        com.pulumi.azurenative.datareplication.inputs.AzStackHCIFabricModelCustomPropertiesArgs.builder()
            .azStackHciSiteId(azStackHciSiteId.applyValue({ args0 -> args0 }))
            .cluster(cluster.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .migrationSolutionId(migrationSolutionId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzStackHCIFabricModelCustomPropertiesArgs].
 */
@PulumiTagMarker
public class AzStackHCIFabricModelCustomPropertiesArgsBuilder internal constructor() {
    private var azStackHciSiteId: Output<String>? = null

    private var cluster: Output<AzStackHCIClusterPropertiesArgs>? = null

    private var instanceType: Output<String>? = null

    private var migrationSolutionId: Output<String>? = null

    /**
     * @param value Gets or sets the ARM Id of the AzStackHCI site.
     */
    @JvmName("kouguifaydliccwv")
    public suspend fun azStackHciSiteId(`value`: Output<String>) {
        this.azStackHciSiteId = value
    }

    /**
     * @param value AzStackHCI cluster properties.
     */
    @JvmName("ksybxhbmxsqxhqpv")
    public suspend fun cluster(`value`: Output<AzStackHCIClusterPropertiesArgs>) {
        this.cluster = value
    }

    /**
     * @param value Gets or sets the instance type.
     * Expected value is 'AzStackHCI'.
     */
    @JvmName("fvgvqokelfjjqlql")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Gets or sets the Migration solution ARM Id.
     */
    @JvmName("hpoovqjxnfipgygs")
    public suspend fun migrationSolutionId(`value`: Output<String>) {
        this.migrationSolutionId = value
    }

    /**
     * @param value Gets or sets the ARM Id of the AzStackHCI site.
     */
    @JvmName("xitktmmjyiekubmt")
    public suspend fun azStackHciSiteId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azStackHciSiteId = mapped
    }

    /**
     * @param value AzStackHCI cluster properties.
     */
    @JvmName("xjrxrrsfkpmyqmcn")
    public suspend fun cluster(`value`: AzStackHCIClusterPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cluster = mapped
    }

    /**
     * @param argument AzStackHCI cluster properties.
     */
    @JvmName("bhfmbcumbgmxgjlp")
    public suspend fun cluster(argument: suspend AzStackHCIClusterPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AzStackHCIClusterPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cluster = mapped
    }

    /**
     * @param value Gets or sets the instance type.
     * Expected value is 'AzStackHCI'.
     */
    @JvmName("hxjkhddgbfvbemaf")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Gets or sets the Migration solution ARM Id.
     */
    @JvmName("ylgdpvttcihubnov")
    public suspend fun migrationSolutionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.migrationSolutionId = mapped
    }

    internal fun build(): AzStackHCIFabricModelCustomPropertiesArgs =
        AzStackHCIFabricModelCustomPropertiesArgs(
            azStackHciSiteId = azStackHciSiteId ?: throw PulumiNullFieldException("azStackHciSiteId"),
            cluster = cluster ?: throw PulumiNullFieldException("cluster"),
            instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
            migrationSolutionId = migrationSolutionId ?: throw PulumiNullFieldException("migrationSolutionId"),
        )
}
