@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.inputs

import com.pulumi.azurenative.datareplication.inputs.HyperVToAzStackHCIDiskInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * HyperVToAzStack disk input.
 * @property diskFileFormat Gets or sets the type of the virtual hard disk, vhd or vhdx.
 * @property diskId Gets or sets the disk Id.
 * @property diskSizeGB Gets or sets the disk size in GB.
 * @property isDynamic Gets or sets a value indicating whether dynamic sizing is enabled on the virtual hard
 * disk.
 * @property isOsDisk Gets or sets a value indicating whether disk is os disk.
 * @property storageContainerId Gets or sets the target storage account ARM Id.
 */
public data class HyperVToAzStackHCIDiskInputArgs(
    public val diskFileFormat: Output<String>,
    public val diskId: Output<String>,
    public val diskSizeGB: Output<Double>,
    public val isDynamic: Output<Boolean>? = null,
    public val isOsDisk: Output<Boolean>,
    public val storageContainerId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datareplication.inputs.HyperVToAzStackHCIDiskInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.datareplication.inputs.HyperVToAzStackHCIDiskInputArgs =
        com.pulumi.azurenative.datareplication.inputs.HyperVToAzStackHCIDiskInputArgs.builder()
            .diskFileFormat(diskFileFormat.applyValue({ args0 -> args0 }))
            .diskId(diskId.applyValue({ args0 -> args0 }))
            .diskSizeGB(diskSizeGB.applyValue({ args0 -> args0 }))
            .isDynamic(isDynamic?.applyValue({ args0 -> args0 }))
            .isOsDisk(isOsDisk.applyValue({ args0 -> args0 }))
            .storageContainerId(storageContainerId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HyperVToAzStackHCIDiskInputArgs].
 */
@PulumiTagMarker
public class HyperVToAzStackHCIDiskInputArgsBuilder internal constructor() {
    private var diskFileFormat: Output<String>? = null

    private var diskId: Output<String>? = null

    private var diskSizeGB: Output<Double>? = null

    private var isDynamic: Output<Boolean>? = null

    private var isOsDisk: Output<Boolean>? = null

    private var storageContainerId: Output<String>? = null

    /**
     * @param value Gets or sets the type of the virtual hard disk, vhd or vhdx.
     */
    @JvmName("ebjllscqwywvuptl")
    public suspend fun diskFileFormat(`value`: Output<String>) {
        this.diskFileFormat = value
    }

    /**
     * @param value Gets or sets the disk Id.
     */
    @JvmName("tjcgvtncgehcmufo")
    public suspend fun diskId(`value`: Output<String>) {
        this.diskId = value
    }

    /**
     * @param value Gets or sets the disk size in GB.
     */
    @JvmName("xnhtogrcqekbmggw")
    public suspend fun diskSizeGB(`value`: Output<Double>) {
        this.diskSizeGB = value
    }

    /**
     * @param value Gets or sets a value indicating whether dynamic sizing is enabled on the virtual hard
     * disk.
     */
    @JvmName("gdscchmfwadbowtm")
    public suspend fun isDynamic(`value`: Output<Boolean>) {
        this.isDynamic = value
    }

    /**
     * @param value Gets or sets a value indicating whether disk is os disk.
     */
    @JvmName("jywigiropneefmbg")
    public suspend fun isOsDisk(`value`: Output<Boolean>) {
        this.isOsDisk = value
    }

    /**
     * @param value Gets or sets the target storage account ARM Id.
     */
    @JvmName("gsywuicwjmegivyu")
    public suspend fun storageContainerId(`value`: Output<String>) {
        this.storageContainerId = value
    }

    /**
     * @param value Gets or sets the type of the virtual hard disk, vhd or vhdx.
     */
    @JvmName("bnqxniykkgctlpug")
    public suspend fun diskFileFormat(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskFileFormat = mapped
    }

    /**
     * @param value Gets or sets the disk Id.
     */
    @JvmName("avtbruyiyrqjjcnm")
    public suspend fun diskId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskId = mapped
    }

    /**
     * @param value Gets or sets the disk size in GB.
     */
    @JvmName("tevgougrgslxffxf")
    public suspend fun diskSizeGB(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskSizeGB = mapped
    }

    /**
     * @param value Gets or sets a value indicating whether dynamic sizing is enabled on the virtual hard
     * disk.
     */
    @JvmName("ehsjbunppwmbcaev")
    public suspend fun isDynamic(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isDynamic = mapped
    }

    /**
     * @param value Gets or sets a value indicating whether disk is os disk.
     */
    @JvmName("kwtfonodtjgaeqfd")
    public suspend fun isOsDisk(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isOsDisk = mapped
    }

    /**
     * @param value Gets or sets the target storage account ARM Id.
     */
    @JvmName("ltunbjxbcfubkrqp")
    public suspend fun storageContainerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageContainerId = mapped
    }

    internal fun build(): HyperVToAzStackHCIDiskInputArgs = HyperVToAzStackHCIDiskInputArgs(
        diskFileFormat = diskFileFormat ?: throw PulumiNullFieldException("diskFileFormat"),
        diskId = diskId ?: throw PulumiNullFieldException("diskId"),
        diskSizeGB = diskSizeGB ?: throw PulumiNullFieldException("diskSizeGB"),
        isDynamic = isDynamic,
        isOsDisk = isOsDisk ?: throw PulumiNullFieldException("isOsDisk"),
        storageContainerId = storageContainerId,
    )
}
