@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.inputs

import com.pulumi.azurenative.datareplication.inputs.HyperVToAzStackHCIProtectedItemModelCustomPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * HyperV to AzStackHCI Protected item model custom properties.
 * @property customLocationRegion Gets or sets the location of Azure Arc HCI custom location resource.
 * @property disksToInclude Gets or sets the list of disks to replicate.
 * @property dynamicMemoryConfig Protected item dynamic memory config.
 * @property fabricDiscoveryMachineId Gets or sets the ARM Id of the discovered machine.
 * @property hyperVGeneration Gets or sets the hypervisor generation of the virtual machine.
 * @property instanceType Gets or sets the instance type.
 * Expected value is 'HyperVToAzStackHCI'.
 * @property isDynamicRam Gets or sets a value indicating whether memory is dynamical.
 * @property nicsToInclude Gets or sets the list of VM NIC to replicate.
 * @property runAsAccountId Gets or sets the Run As account Id.
 * @property sourceDraName Gets or sets the source DRA name.
 * @property storageContainerId Gets or sets the target storage container ARM Id.
 * @property targetArcClusterCustomLocationId Gets or sets the Target Arc Cluster Custom Location ARM Id.
 * @property targetCpuCores Gets or sets the target CPU cores.
 * @property targetDraName Gets or sets the target DRA name.
 * @property targetHciClusterId Gets or sets the Target HCI Cluster ARM Id.
 * @property targetMemoryInMegaBytes Gets or sets the target memory in mega-bytes.
 * @property targetNetworkId Gets or sets the target network Id within AzStackHCI Cluster.
 * @property targetResourceGroupId Gets or sets the target resource group ARM Id.
 * @property targetVmName Gets or sets the target VM display name.
 * @property testNetworkId Gets or sets the target test network Id within AzStackHCI Cluster.
 */
public data class HyperVToAzStackHCIProtectedItemModelCustomPropertiesArgs(
    public val customLocationRegion: Output<String>,
    public val disksToInclude: Output<List<HyperVToAzStackHCIDiskInputArgs>>,
    public val dynamicMemoryConfig: Output<ProtectedItemDynamicMemoryConfigArgs>? = null,
    public val fabricDiscoveryMachineId: Output<String>,
    public val hyperVGeneration: Output<String>,
    public val instanceType: Output<String>,
    public val isDynamicRam: Output<Boolean>? = null,
    public val nicsToInclude: Output<List<HyperVToAzStackHCINicInputArgs>>,
    public val runAsAccountId: Output<String>,
    public val sourceDraName: Output<String>,
    public val storageContainerId: Output<String>,
    public val targetArcClusterCustomLocationId: Output<String>,
    public val targetCpuCores: Output<Int>? = null,
    public val targetDraName: Output<String>,
    public val targetHciClusterId: Output<String>,
    public val targetMemoryInMegaBytes: Output<Int>? = null,
    public val targetNetworkId: Output<String>? = null,
    public val targetResourceGroupId: Output<String>,
    public val targetVmName: Output<String>? = null,
    public val testNetworkId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.datareplication.inputs.HyperVToAzStackHCIProtectedItemModelCustomPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.datareplication.inputs.HyperVToAzStackHCIProtectedItemModelCustomPropertiesArgs =
        com.pulumi.azurenative.datareplication.inputs.HyperVToAzStackHCIProtectedItemModelCustomPropertiesArgs.builder()
            .customLocationRegion(customLocationRegion.applyValue({ args0 -> args0 }))
            .disksToInclude(
                disksToInclude.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .dynamicMemoryConfig(
                dynamicMemoryConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .fabricDiscoveryMachineId(fabricDiscoveryMachineId.applyValue({ args0 -> args0 }))
            .hyperVGeneration(hyperVGeneration.applyValue({ args0 -> args0 }))
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .isDynamicRam(isDynamicRam?.applyValue({ args0 -> args0 }))
            .nicsToInclude(
                nicsToInclude.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .runAsAccountId(runAsAccountId.applyValue({ args0 -> args0 }))
            .sourceDraName(sourceDraName.applyValue({ args0 -> args0 }))
            .storageContainerId(storageContainerId.applyValue({ args0 -> args0 }))
            .targetArcClusterCustomLocationId(targetArcClusterCustomLocationId.applyValue({ args0 -> args0 }))
            .targetCpuCores(targetCpuCores?.applyValue({ args0 -> args0 }))
            .targetDraName(targetDraName.applyValue({ args0 -> args0 }))
            .targetHciClusterId(targetHciClusterId.applyValue({ args0 -> args0 }))
            .targetMemoryInMegaBytes(targetMemoryInMegaBytes?.applyValue({ args0 -> args0 }))
            .targetNetworkId(targetNetworkId?.applyValue({ args0 -> args0 }))
            .targetResourceGroupId(targetResourceGroupId.applyValue({ args0 -> args0 }))
            .targetVmName(targetVmName?.applyValue({ args0 -> args0 }))
            .testNetworkId(testNetworkId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HyperVToAzStackHCIProtectedItemModelCustomPropertiesArgs].
 */
@PulumiTagMarker
public class HyperVToAzStackHCIProtectedItemModelCustomPropertiesArgsBuilder internal constructor() {
    private var customLocationRegion: Output<String>? = null

    private var disksToInclude: Output<List<HyperVToAzStackHCIDiskInputArgs>>? = null

    private var dynamicMemoryConfig: Output<ProtectedItemDynamicMemoryConfigArgs>? = null

    private var fabricDiscoveryMachineId: Output<String>? = null

    private var hyperVGeneration: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var isDynamicRam: Output<Boolean>? = null

    private var nicsToInclude: Output<List<HyperVToAzStackHCINicInputArgs>>? = null

    private var runAsAccountId: Output<String>? = null

    private var sourceDraName: Output<String>? = null

    private var storageContainerId: Output<String>? = null

    private var targetArcClusterCustomLocationId: Output<String>? = null

    private var targetCpuCores: Output<Int>? = null

    private var targetDraName: Output<String>? = null

    private var targetHciClusterId: Output<String>? = null

    private var targetMemoryInMegaBytes: Output<Int>? = null

    private var targetNetworkId: Output<String>? = null

    private var targetResourceGroupId: Output<String>? = null

    private var targetVmName: Output<String>? = null

    private var testNetworkId: Output<String>? = null

    /**
     * @param value Gets or sets the location of Azure Arc HCI custom location resource.
     */
    @JvmName("qhdpasojmdtqeudo")
    public suspend fun customLocationRegion(`value`: Output<String>) {
        this.customLocationRegion = value
    }

    /**
     * @param value Gets or sets the list of disks to replicate.
     */
    @JvmName("cifqnjkwjeedyetw")
    public suspend fun disksToInclude(`value`: Output<List<HyperVToAzStackHCIDiskInputArgs>>) {
        this.disksToInclude = value
    }

    @JvmName("wnnvcsvywmvqmekc")
    public suspend fun disksToInclude(vararg values: Output<HyperVToAzStackHCIDiskInputArgs>) {
        this.disksToInclude = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the list of disks to replicate.
     */
    @JvmName("lbgtepfxtddwgvwe")
    public suspend fun disksToInclude(values: List<Output<HyperVToAzStackHCIDiskInputArgs>>) {
        this.disksToInclude = Output.all(values)
    }

    /**
     * @param value Protected item dynamic memory config.
     */
    @JvmName("imjwhyunswctltow")
    public suspend fun dynamicMemoryConfig(`value`: Output<ProtectedItemDynamicMemoryConfigArgs>) {
        this.dynamicMemoryConfig = value
    }

    /**
     * @param value Gets or sets the ARM Id of the discovered machine.
     */
    @JvmName("bmgvgqivdrjvpnkm")
    public suspend fun fabricDiscoveryMachineId(`value`: Output<String>) {
        this.fabricDiscoveryMachineId = value
    }

    /**
     * @param value Gets or sets the hypervisor generation of the virtual machine.
     */
    @JvmName("bfjcksmbegomqsbv")
    public suspend fun hyperVGeneration(`value`: Output<String>) {
        this.hyperVGeneration = value
    }

    /**
     * @param value Gets or sets the instance type.
     * Expected value is 'HyperVToAzStackHCI'.
     */
    @JvmName("uwvllkrtfuqpulyi")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Gets or sets a value indicating whether memory is dynamical.
     */
    @JvmName("yvdhagtbiddoshmr")
    public suspend fun isDynamicRam(`value`: Output<Boolean>) {
        this.isDynamicRam = value
    }

    /**
     * @param value Gets or sets the list of VM NIC to replicate.
     */
    @JvmName("bifaxujxxkbymjew")
    public suspend fun nicsToInclude(`value`: Output<List<HyperVToAzStackHCINicInputArgs>>) {
        this.nicsToInclude = value
    }

    @JvmName("yrtjhbplpxhwngtb")
    public suspend fun nicsToInclude(vararg values: Output<HyperVToAzStackHCINicInputArgs>) {
        this.nicsToInclude = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the list of VM NIC to replicate.
     */
    @JvmName("hpwctymrertidjcq")
    public suspend fun nicsToInclude(values: List<Output<HyperVToAzStackHCINicInputArgs>>) {
        this.nicsToInclude = Output.all(values)
    }

    /**
     * @param value Gets or sets the Run As account Id.
     */
    @JvmName("ycgdjyriimnmlrtv")
    public suspend fun runAsAccountId(`value`: Output<String>) {
        this.runAsAccountId = value
    }

    /**
     * @param value Gets or sets the source DRA name.
     */
    @JvmName("tqkwinbjcgerjlth")
    public suspend fun sourceDraName(`value`: Output<String>) {
        this.sourceDraName = value
    }

    /**
     * @param value Gets or sets the target storage container ARM Id.
     */
    @JvmName("pkbsgcsmsoukehqd")
    public suspend fun storageContainerId(`value`: Output<String>) {
        this.storageContainerId = value
    }

    /**
     * @param value Gets or sets the Target Arc Cluster Custom Location ARM Id.
     */
    @JvmName("yyeobepejinqelqr")
    public suspend fun targetArcClusterCustomLocationId(`value`: Output<String>) {
        this.targetArcClusterCustomLocationId = value
    }

    /**
     * @param value Gets or sets the target CPU cores.
     */
    @JvmName("njfsppnblcshmkqe")
    public suspend fun targetCpuCores(`value`: Output<Int>) {
        this.targetCpuCores = value
    }

    /**
     * @param value Gets or sets the target DRA name.
     */
    @JvmName("dgalcweqgaipocjn")
    public suspend fun targetDraName(`value`: Output<String>) {
        this.targetDraName = value
    }

    /**
     * @param value Gets or sets the Target HCI Cluster ARM Id.
     */
    @JvmName("bsyyomxcfxwhwtrm")
    public suspend fun targetHciClusterId(`value`: Output<String>) {
        this.targetHciClusterId = value
    }

    /**
     * @param value Gets or sets the target memory in mega-bytes.
     */
    @JvmName("rsuencpkodrrkuun")
    public suspend fun targetMemoryInMegaBytes(`value`: Output<Int>) {
        this.targetMemoryInMegaBytes = value
    }

    /**
     * @param value Gets or sets the target network Id within AzStackHCI Cluster.
     */
    @JvmName("bwvuaokadrrrrfxf")
    public suspend fun targetNetworkId(`value`: Output<String>) {
        this.targetNetworkId = value
    }

    /**
     * @param value Gets or sets the target resource group ARM Id.
     */
    @JvmName("cqwaiictxmkcashl")
    public suspend fun targetResourceGroupId(`value`: Output<String>) {
        this.targetResourceGroupId = value
    }

    /**
     * @param value Gets or sets the target VM display name.
     */
    @JvmName("myfxxbypbnvglgha")
    public suspend fun targetVmName(`value`: Output<String>) {
        this.targetVmName = value
    }

    /**
     * @param value Gets or sets the target test network Id within AzStackHCI Cluster.
     */
    @JvmName("cgapgntulsnvvckn")
    public suspend fun testNetworkId(`value`: Output<String>) {
        this.testNetworkId = value
    }

    /**
     * @param value Gets or sets the location of Azure Arc HCI custom location resource.
     */
    @JvmName("iajanisekurtkuxq")
    public suspend fun customLocationRegion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customLocationRegion = mapped
    }

    /**
     * @param value Gets or sets the list of disks to replicate.
     */
    @JvmName("dgrdwjmdrwfhwqfo")
    public suspend fun disksToInclude(`value`: List<HyperVToAzStackHCIDiskInputArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.disksToInclude = mapped
    }

    /**
     * @param argument Gets or sets the list of disks to replicate.
     */
    @JvmName("vtydxlsuqcjkeens")
    public suspend
    fun disksToInclude(argument: List<suspend HyperVToAzStackHCIDiskInputArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            HyperVToAzStackHCIDiskInputArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.disksToInclude = mapped
    }

    /**
     * @param argument Gets or sets the list of disks to replicate.
     */
    @JvmName("vsevubcpawinwqty")
    public suspend fun disksToInclude(
        vararg
        argument: suspend HyperVToAzStackHCIDiskInputArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            HyperVToAzStackHCIDiskInputArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.disksToInclude = mapped
    }

    /**
     * @param argument Gets or sets the list of disks to replicate.
     */
    @JvmName("njtyevueaufoeysw")
    public suspend
    fun disksToInclude(argument: suspend HyperVToAzStackHCIDiskInputArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            HyperVToAzStackHCIDiskInputArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.disksToInclude = mapped
    }

    /**
     * @param values Gets or sets the list of disks to replicate.
     */
    @JvmName("fmnipdgofetsxppy")
    public suspend fun disksToInclude(vararg values: HyperVToAzStackHCIDiskInputArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.disksToInclude = mapped
    }

    /**
     * @param value Protected item dynamic memory config.
     */
    @JvmName("ptvbiaidudwoosgq")
    public suspend fun dynamicMemoryConfig(`value`: ProtectedItemDynamicMemoryConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dynamicMemoryConfig = mapped
    }

    /**
     * @param argument Protected item dynamic memory config.
     */
    @JvmName("friqmxxtsmmouybj")
    public suspend
    fun dynamicMemoryConfig(argument: suspend ProtectedItemDynamicMemoryConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ProtectedItemDynamicMemoryConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dynamicMemoryConfig = mapped
    }

    /**
     * @param value Gets or sets the ARM Id of the discovered machine.
     */
    @JvmName("popahrdlxrglpivh")
    public suspend fun fabricDiscoveryMachineId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fabricDiscoveryMachineId = mapped
    }

    /**
     * @param value Gets or sets the hypervisor generation of the virtual machine.
     */
    @JvmName("qpmfnstowmujqalm")
    public suspend fun hyperVGeneration(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hyperVGeneration = mapped
    }

    /**
     * @param value Gets or sets the instance type.
     * Expected value is 'HyperVToAzStackHCI'.
     */
    @JvmName("hqikarqlqwjffori")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Gets or sets a value indicating whether memory is dynamical.
     */
    @JvmName("pcudcaidevscpmab")
    public suspend fun isDynamicRam(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isDynamicRam = mapped
    }

    /**
     * @param value Gets or sets the list of VM NIC to replicate.
     */
    @JvmName("lqdgerdtptthutsf")
    public suspend fun nicsToInclude(`value`: List<HyperVToAzStackHCINicInputArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nicsToInclude = mapped
    }

    /**
     * @param argument Gets or sets the list of VM NIC to replicate.
     */
    @JvmName("txnlxnuhpmgrhhwn")
    public suspend
    fun nicsToInclude(argument: List<suspend HyperVToAzStackHCINicInputArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            HyperVToAzStackHCINicInputArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.nicsToInclude = mapped
    }

    /**
     * @param argument Gets or sets the list of VM NIC to replicate.
     */
    @JvmName("djiujwqpglyksbfr")
    public suspend fun nicsToInclude(
        vararg
        argument: suspend HyperVToAzStackHCINicInputArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            HyperVToAzStackHCINicInputArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.nicsToInclude = mapped
    }

    /**
     * @param argument Gets or sets the list of VM NIC to replicate.
     */
    @JvmName("kqlbnsopbrvydwxr")
    public suspend
    fun nicsToInclude(argument: suspend HyperVToAzStackHCINicInputArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            HyperVToAzStackHCINicInputArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.nicsToInclude = mapped
    }

    /**
     * @param values Gets or sets the list of VM NIC to replicate.
     */
    @JvmName("qpcrfgowdbratgjd")
    public suspend fun nicsToInclude(vararg values: HyperVToAzStackHCINicInputArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nicsToInclude = mapped
    }

    /**
     * @param value Gets or sets the Run As account Id.
     */
    @JvmName("fhfgxqhahivjpapd")
    public suspend fun runAsAccountId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.runAsAccountId = mapped
    }

    /**
     * @param value Gets or sets the source DRA name.
     */
    @JvmName("jinyvdhknddhhnes")
    public suspend fun sourceDraName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceDraName = mapped
    }

    /**
     * @param value Gets or sets the target storage container ARM Id.
     */
    @JvmName("qfksfwrifyowrjms")
    public suspend fun storageContainerId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageContainerId = mapped
    }

    /**
     * @param value Gets or sets the Target Arc Cluster Custom Location ARM Id.
     */
    @JvmName("lyfltfeomukmfucc")
    public suspend fun targetArcClusterCustomLocationId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetArcClusterCustomLocationId = mapped
    }

    /**
     * @param value Gets or sets the target CPU cores.
     */
    @JvmName("pmckcdpthwtlvowe")
    public suspend fun targetCpuCores(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetCpuCores = mapped
    }

    /**
     * @param value Gets or sets the target DRA name.
     */
    @JvmName("tylmtrtncjtxaoch")
    public suspend fun targetDraName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetDraName = mapped
    }

    /**
     * @param value Gets or sets the Target HCI Cluster ARM Id.
     */
    @JvmName("kepilslkykrnqqnu")
    public suspend fun targetHciClusterId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetHciClusterId = mapped
    }

    /**
     * @param value Gets or sets the target memory in mega-bytes.
     */
    @JvmName("gwxumqwuohxguywp")
    public suspend fun targetMemoryInMegaBytes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetMemoryInMegaBytes = mapped
    }

    /**
     * @param value Gets or sets the target network Id within AzStackHCI Cluster.
     */
    @JvmName("ybsusiteehxewhpc")
    public suspend fun targetNetworkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetNetworkId = mapped
    }

    /**
     * @param value Gets or sets the target resource group ARM Id.
     */
    @JvmName("nqaeqiiwqhpagvfd")
    public suspend fun targetResourceGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetResourceGroupId = mapped
    }

    /**
     * @param value Gets or sets the target VM display name.
     */
    @JvmName("pnkbblewrkgjhvsw")
    public suspend fun targetVmName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetVmName = mapped
    }

    /**
     * @param value Gets or sets the target test network Id within AzStackHCI Cluster.
     */
    @JvmName("urhyncdefvyhovgv")
    public suspend fun testNetworkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testNetworkId = mapped
    }

    internal fun build(): HyperVToAzStackHCIProtectedItemModelCustomPropertiesArgs =
        HyperVToAzStackHCIProtectedItemModelCustomPropertiesArgs(
            customLocationRegion = customLocationRegion ?: throw
                PulumiNullFieldException("customLocationRegion"),
            disksToInclude = disksToInclude ?: throw PulumiNullFieldException("disksToInclude"),
            dynamicMemoryConfig = dynamicMemoryConfig,
            fabricDiscoveryMachineId = fabricDiscoveryMachineId ?: throw
                PulumiNullFieldException("fabricDiscoveryMachineId"),
            hyperVGeneration = hyperVGeneration ?: throw PulumiNullFieldException("hyperVGeneration"),
            instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
            isDynamicRam = isDynamicRam,
            nicsToInclude = nicsToInclude ?: throw PulumiNullFieldException("nicsToInclude"),
            runAsAccountId = runAsAccountId ?: throw PulumiNullFieldException("runAsAccountId"),
            sourceDraName = sourceDraName ?: throw PulumiNullFieldException("sourceDraName"),
            storageContainerId = storageContainerId ?: throw PulumiNullFieldException("storageContainerId"),
            targetArcClusterCustomLocationId = targetArcClusterCustomLocationId ?: throw
                PulumiNullFieldException("targetArcClusterCustomLocationId"),
            targetCpuCores = targetCpuCores,
            targetDraName = targetDraName ?: throw PulumiNullFieldException("targetDraName"),
            targetHciClusterId = targetHciClusterId ?: throw PulumiNullFieldException("targetHciClusterId"),
            targetMemoryInMegaBytes = targetMemoryInMegaBytes,
            targetNetworkId = targetNetworkId,
            targetResourceGroupId = targetResourceGroupId ?: throw
                PulumiNullFieldException("targetResourceGroupId"),
            targetVmName = targetVmName,
            testNetworkId = testNetworkId,
        )
}
