@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.inputs

import com.pulumi.azurenative.datareplication.inputs.ProtectedItemDynamicMemoryConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Protected item dynamic memory config.
 * @property maximumMemoryInMegaBytes Gets or sets maximum memory in MB.
 * @property minimumMemoryInMegaBytes Gets or sets minimum memory in MB.
 * @property targetMemoryBufferPercentage Gets or sets target memory buffer in %.
 */
public data class ProtectedItemDynamicMemoryConfigArgs(
    public val maximumMemoryInMegaBytes: Output<Double>,
    public val minimumMemoryInMegaBytes: Output<Double>,
    public val targetMemoryBufferPercentage: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datareplication.inputs.ProtectedItemDynamicMemoryConfigArgs> {
    override fun toJava():
        com.pulumi.azurenative.datareplication.inputs.ProtectedItemDynamicMemoryConfigArgs =
        com.pulumi.azurenative.datareplication.inputs.ProtectedItemDynamicMemoryConfigArgs.builder()
            .maximumMemoryInMegaBytes(maximumMemoryInMegaBytes.applyValue({ args0 -> args0 }))
            .minimumMemoryInMegaBytes(minimumMemoryInMegaBytes.applyValue({ args0 -> args0 }))
            .targetMemoryBufferPercentage(targetMemoryBufferPercentage.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProtectedItemDynamicMemoryConfigArgs].
 */
@PulumiTagMarker
public class ProtectedItemDynamicMemoryConfigArgsBuilder internal constructor() {
    private var maximumMemoryInMegaBytes: Output<Double>? = null

    private var minimumMemoryInMegaBytes: Output<Double>? = null

    private var targetMemoryBufferPercentage: Output<Int>? = null

    /**
     * @param value Gets or sets maximum memory in MB.
     */
    @JvmName("cvbyhsndqpklxeme")
    public suspend fun maximumMemoryInMegaBytes(`value`: Output<Double>) {
        this.maximumMemoryInMegaBytes = value
    }

    /**
     * @param value Gets or sets minimum memory in MB.
     */
    @JvmName("funrqyksvnatpoyo")
    public suspend fun minimumMemoryInMegaBytes(`value`: Output<Double>) {
        this.minimumMemoryInMegaBytes = value
    }

    /**
     * @param value Gets or sets target memory buffer in %.
     */
    @JvmName("eqobgiuuoymjgrar")
    public suspend fun targetMemoryBufferPercentage(`value`: Output<Int>) {
        this.targetMemoryBufferPercentage = value
    }

    /**
     * @param value Gets or sets maximum memory in MB.
     */
    @JvmName("csjasfwuuqbldtwc")
    public suspend fun maximumMemoryInMegaBytes(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maximumMemoryInMegaBytes = mapped
    }

    /**
     * @param value Gets or sets minimum memory in MB.
     */
    @JvmName("qsfdlsujhhhgghxt")
    public suspend fun minimumMemoryInMegaBytes(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minimumMemoryInMegaBytes = mapped
    }

    /**
     * @param value Gets or sets target memory buffer in %.
     */
    @JvmName("lrywhdoclhtgsadn")
    public suspend fun targetMemoryBufferPercentage(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetMemoryBufferPercentage = mapped
    }

    internal fun build(): ProtectedItemDynamicMemoryConfigArgs = ProtectedItemDynamicMemoryConfigArgs(
        maximumMemoryInMegaBytes = maximumMemoryInMegaBytes ?: throw
            PulumiNullFieldException("maximumMemoryInMegaBytes"),
        minimumMemoryInMegaBytes = minimumMemoryInMegaBytes ?: throw
            PulumiNullFieldException("minimumMemoryInMegaBytes"),
        targetMemoryBufferPercentage = targetMemoryBufferPercentage ?: throw
            PulumiNullFieldException("targetMemoryBufferPercentage"),
    )
}
