@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Dra model properties.
 * @property authenticationIdentity Identity model.
 * @property correlationId Gets or sets the Dra correlation Id.
 * @property customProperties Dra model custom properties.
 * @property healthErrors Gets or sets the list of health errors.
 * @property isResponsive Gets or sets a value indicating whether Dra is responsive.
 * @property lastHeartbeat Gets or sets the time when last heartbeat was sent by the Dra.
 * @property machineId Gets or sets the machine Id where Dra is running.
 * @property machineName Gets or sets the machine name where Dra is running.
 * @property provisioningState Gets or sets the provisioning state of the Dra.
 * @property resourceAccessIdentity Identity model.
 * @property versionNumber Gets or sets the Dra version.
 */
public data class DraModelPropertiesResponse(
    public val authenticationIdentity: IdentityModelResponse,
    public val correlationId: String,
    public val customProperties: VMwareDraModelCustomPropertiesResponse,
    public val healthErrors: List<HealthErrorModelResponse>,
    public val isResponsive: Boolean,
    public val lastHeartbeat: String,
    public val machineId: String,
    public val machineName: String,
    public val provisioningState: String,
    public val resourceAccessIdentity: IdentityModelResponse,
    public val versionNumber: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datareplication.outputs.DraModelPropertiesResponse):
            DraModelPropertiesResponse = DraModelPropertiesResponse(
            authenticationIdentity = javaType.authenticationIdentity().let({ args0 ->
                com.pulumi.azurenative.datareplication.kotlin.outputs.IdentityModelResponse.Companion.toKotlin(args0)
            }),
            correlationId = javaType.correlationId(),
            customProperties = javaType.customProperties().let({ args0 ->
                com.pulumi.azurenative.datareplication.kotlin.outputs.VMwareDraModelCustomPropertiesResponse.Companion.toKotlin(args0)
            }),
            healthErrors = javaType.healthErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datareplication.kotlin.outputs.HealthErrorModelResponse.Companion.toKotlin(args0)
                })
            }),
            isResponsive = javaType.isResponsive(),
            lastHeartbeat = javaType.lastHeartbeat(),
            machineId = javaType.machineId(),
            machineName = javaType.machineName(),
            provisioningState = javaType.provisioningState(),
            resourceAccessIdentity = javaType.resourceAccessIdentity().let({ args0 ->
                com.pulumi.azurenative.datareplication.kotlin.outputs.IdentityModelResponse.Companion.toKotlin(args0)
            }),
            versionNumber = javaType.versionNumber(),
        )
    }
}
