@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Replication extension model.
 * @property id Gets or sets the Id of the resource.
 * @property name Gets or sets the name of the resource.
 * @property properties Replication extension model properties.
 * @property systemData
 * @property type Gets or sets the type of the resource.
 */
public data class GetReplicationExtensionResult(
    public val id: String,
    public val name: String,
    public val properties: ReplicationExtensionModelPropertiesResponse,
    public val systemData: ReplicationExtensionModelResponseSystemData,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datareplication.outputs.GetReplicationExtensionResult):
            GetReplicationExtensionResult = GetReplicationExtensionResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.datareplication.kotlin.outputs.ReplicationExtensionModelPropertiesResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.datareplication.kotlin.outputs.ReplicationExtensionModelResponseSystemData.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
