@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * HyperVToAzStackHCI NIC properties.
 * @property networkName Gets or sets the network name.
 * @property nicId Gets or sets the NIC Id.
 * @property selectionTypeForFailover Gets or sets the selection type of the NIC.
 * @property targetNetworkId Gets or sets the target network Id within AzStackHCI Cluster.
 * @property testNetworkId Gets or sets the target test network Id within AzStackHCI Cluster.
 */
public data class HyperVToAzStackHCINicInputResponse(
    public val networkName: String,
    public val nicId: String,
    public val selectionTypeForFailover: String,
    public val targetNetworkId: String,
    public val testNetworkId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datareplication.outputs.HyperVToAzStackHCINicInputResponse):
            HyperVToAzStackHCINicInputResponse = HyperVToAzStackHCINicInputResponse(
            networkName = javaType.networkName(),
            nicId = javaType.nicId(),
            selectionTypeForFailover = javaType.selectionTypeForFailover(),
            targetNetworkId = javaType.targetNetworkId(),
            testNetworkId = javaType.testNetworkId(),
        )
    }
}
