@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress

/**
 * Policy model properties.
 * @property customProperties Policy model custom properties.
 * @property provisioningState Gets or sets the provisioning state of the policy.
 */
public data class PolicyModelPropertiesResponse(
    public val customProperties:
    Either<HyperVToAzStackHCIPolicyModelCustomPropertiesResponse, VMwareToAzStackHCIPolicyModelCustomPropertiesResponse>,
    public val provisioningState: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datareplication.outputs.PolicyModelPropertiesResponse):
            PolicyModelPropertiesResponse = PolicyModelPropertiesResponse(
            customProperties = javaType.customProperties().transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datareplication.kotlin.outputs.HyperVToAzStackHCIPolicyModelCustomPropertiesResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datareplication.kotlin.outputs.VMwareToAzStackHCIPolicyModelCustomPropertiesResponse.Companion.toKotlin(args0)
                    })
                },
            ),
            provisioningState = javaType.provisioningState(),
        )
    }
}
