@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin

import com.pulumi.azurenative.datashare.ADLSGen2FileDataSetMappingArgs.builder
import com.pulumi.azurenative.datashare.kotlin.enums.OutputType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An ADLS Gen2 file data set mapping.
 * Azure REST API version: 2021-08-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * ## Example Usage
 * ### DataSetMappings_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var adlsGen2FileDataSetMapping = new AzureNative.DataShare.ADLSGen2FileDataSetMapping("adlsGen2FileDataSetMapping", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetMappingName = "DatasetMapping1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareSubscriptionName = "ShareSubscription1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewADLSGen2FileDataSetMapping(ctx, "adlsGen2FileDataSetMapping", &datashare.ADLSGen2FileDataSetMappingArgs{
 * 			AccountName:           pulumi.String("Account1"),
 * 			DataSetMappingName:    pulumi.String("DatasetMapping1"),
 * 			ResourceGroupName:     pulumi.String("SampleResourceGroup"),
 * 			ShareSubscriptionName: pulumi.String("ShareSubscription1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.ADLSGen2FileDataSetMapping;
 * import com.pulumi.azurenative.datashare.ADLSGen2FileDataSetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var adlsGen2FileDataSetMapping = new ADLSGen2FileDataSetMapping("adlsGen2FileDataSetMapping", ADLSGen2FileDataSetMappingArgs.builder()
 *             .accountName("Account1")
 *             .dataSetMappingName("DatasetMapping1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSetMappings_SqlDB_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var adlsGen2FileDataSetMapping = new AzureNative.DataShare.ADLSGen2FileDataSetMapping("adlsGen2FileDataSetMapping", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetMappingName = "DatasetMapping1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareSubscriptionName = "ShareSubscription1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewADLSGen2FileDataSetMapping(ctx, "adlsGen2FileDataSetMapping", &datashare.ADLSGen2FileDataSetMappingArgs{
 * 			AccountName:           pulumi.String("Account1"),
 * 			DataSetMappingName:    pulumi.String("DatasetMapping1"),
 * 			ResourceGroupName:     pulumi.String("SampleResourceGroup"),
 * 			ShareSubscriptionName: pulumi.String("ShareSubscription1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.ADLSGen2FileDataSetMapping;
 * import com.pulumi.azurenative.datashare.ADLSGen2FileDataSetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var adlsGen2FileDataSetMapping = new ADLSGen2FileDataSetMapping("adlsGen2FileDataSetMapping", ADLSGen2FileDataSetMappingArgs.builder()
 *             .accountName("Account1")
 *             .dataSetMappingName("DatasetMapping1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSetMappings_SqlDWDataSetToAdlsGen2File_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var adlsGen2FileDataSetMapping = new AzureNative.DataShare.ADLSGen2FileDataSetMapping("adlsGen2FileDataSetMapping", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetId = "a08f184b-0567-4b11-ba22-a1199336d226",
 *         DataSetMappingName = "DatasetMapping1",
 *         FilePath = "file21",
 *         FileSystem = "fileSystem",
 *         Kind = "AdlsGen2File",
 *         OutputType = "Csv",
 *         ResourceGroup = "SampleResourceGroup",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareSubscriptionName = "ShareSubscription1",
 *         StorageAccountName = "storage2",
 *         SubscriptionId = "433a8dfd-e5d5-4e77-ad86-90acdc75eb1a",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewADLSGen2FileDataSetMapping(ctx, "adlsGen2FileDataSetMapping", &datashare.ADLSGen2FileDataSetMappingArgs{
 * 			AccountName:           pulumi.String("Account1"),
 * 			DataSetId:             pulumi.String("a08f184b-0567-4b11-ba22-a1199336d226"),
 * 			DataSetMappingName:    pulumi.String("DatasetMapping1"),
 * 			FilePath:              pulumi.String("file21"),
 * 			FileSystem:            pulumi.String("fileSystem"),
 * 			Kind:                  pulumi.String("AdlsGen2File"),
 * 			OutputType:            pulumi.String("Csv"),
 * 			ResourceGroup:         pulumi.String("SampleResourceGroup"),
 * 			ResourceGroupName:     pulumi.String("SampleResourceGroup"),
 * 			ShareSubscriptionName: pulumi.String("ShareSubscription1"),
 * 			StorageAccountName:    pulumi.String("storage2"),
 * 			SubscriptionId:        pulumi.String("433a8dfd-e5d5-4e77-ad86-90acdc75eb1a"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.ADLSGen2FileDataSetMapping;
 * import com.pulumi.azurenative.datashare.ADLSGen2FileDataSetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var adlsGen2FileDataSetMapping = new ADLSGen2FileDataSetMapping("adlsGen2FileDataSetMapping", ADLSGen2FileDataSetMappingArgs.builder()
 *             .accountName("Account1")
 *             .dataSetId("a08f184b-0567-4b11-ba22-a1199336d226")
 *             .dataSetMappingName("DatasetMapping1")
 *             .filePath("file21")
 *             .fileSystem("fileSystem")
 *             .kind("AdlsGen2File")
 *             .outputType("Csv")
 *             .resourceGroup("SampleResourceGroup")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .storageAccountName("storage2")
 *             .subscriptionId("433a8dfd-e5d5-4e77-ad86-90acdc75eb1a")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSetMappings_SqlDW_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var adlsGen2FileDataSetMapping = new AzureNative.DataShare.ADLSGen2FileDataSetMapping("adlsGen2FileDataSetMapping", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetMappingName = "DatasetMapping1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareSubscriptionName = "ShareSubscription1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewADLSGen2FileDataSetMapping(ctx, "adlsGen2FileDataSetMapping", &datashare.ADLSGen2FileDataSetMappingArgs{
 * 			AccountName:           pulumi.String("Account1"),
 * 			DataSetMappingName:    pulumi.String("DatasetMapping1"),
 * 			ResourceGroupName:     pulumi.String("SampleResourceGroup"),
 * 			ShareSubscriptionName: pulumi.String("ShareSubscription1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.ADLSGen2FileDataSetMapping;
 * import com.pulumi.azurenative.datashare.ADLSGen2FileDataSetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var adlsGen2FileDataSetMapping = new ADLSGen2FileDataSetMapping("adlsGen2FileDataSetMapping", ADLSGen2FileDataSetMappingArgs.builder()
 *             .accountName("Account1")
 *             .dataSetMappingName("DatasetMapping1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSetMappings_SynapseWorkspaceSqlPoolTable_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var adlsGen2FileDataSetMapping = new AzureNative.DataShare.ADLSGen2FileDataSetMapping("adlsGen2FileDataSetMapping", new()
 *     {
 *         AccountName = "consumerAccount",
 *         DataSetMappingName = "datasetMappingName1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareSubscriptionName = "ShareSubscription1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewADLSGen2FileDataSetMapping(ctx, "adlsGen2FileDataSetMapping", &datashare.ADLSGen2FileDataSetMappingArgs{
 * 			AccountName:           pulumi.String("consumerAccount"),
 * 			DataSetMappingName:    pulumi.String("datasetMappingName1"),
 * 			ResourceGroupName:     pulumi.String("SampleResourceGroup"),
 * 			ShareSubscriptionName: pulumi.String("ShareSubscription1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.ADLSGen2FileDataSetMapping;
 * import com.pulumi.azurenative.datashare.ADLSGen2FileDataSetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var adlsGen2FileDataSetMapping = new ADLSGen2FileDataSetMapping("adlsGen2FileDataSetMapping", ADLSGen2FileDataSetMappingArgs.builder()
 *             .accountName("consumerAccount")
 *             .dataSetMappingName("datasetMappingName1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datashare:ADLSGen2FileDataSetMapping datasetMappingName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}/dataSetMappings/{dataSetMappingName}
 * ```
 * @property accountName The name of the share account.
 * @property dataSetId The id of the source data set.
 * @property dataSetMappingName The name of the data set mapping to be created.
 * @property filePath File path within the file system.
 * @property fileSystem File system to which the file belongs.
 * @property kind Kind of data set mapping.
 * Expected value is 'AdlsGen2File'.
 * @property outputType Type of output file
 * @property resourceGroup Resource group of storage account.
 * @property resourceGroupName The resource group name.
 * @property shareSubscriptionName The name of the share subscription which will hold the data set sink.
 * @property storageAccountName Storage account name of the source data set.
 * @property subscriptionId Subscription id of storage account.
 */
public data class ADLSGen2FileDataSetMappingArgs(
    public val accountName: Output<String>? = null,
    public val dataSetId: Output<String>? = null,
    public val dataSetMappingName: Output<String>? = null,
    public val filePath: Output<String>? = null,
    public val fileSystem: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val outputType: Output<Either<String, OutputType>>? = null,
    public val resourceGroup: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val shareSubscriptionName: Output<String>? = null,
    public val storageAccountName: Output<String>? = null,
    public val subscriptionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datashare.ADLSGen2FileDataSetMappingArgs> {
    override fun toJava(): com.pulumi.azurenative.datashare.ADLSGen2FileDataSetMappingArgs =
        com.pulumi.azurenative.datashare.ADLSGen2FileDataSetMappingArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .dataSetId(dataSetId?.applyValue({ args0 -> args0 }))
            .dataSetMappingName(dataSetMappingName?.applyValue({ args0 -> args0 }))
            .filePath(filePath?.applyValue({ args0 -> args0 }))
            .fileSystem(fileSystem?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .outputType(
                outputType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroup(resourceGroup?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .shareSubscriptionName(shareSubscriptionName?.applyValue({ args0 -> args0 }))
            .storageAccountName(storageAccountName?.applyValue({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ADLSGen2FileDataSetMappingArgs].
 */
@PulumiTagMarker
public class ADLSGen2FileDataSetMappingArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var dataSetId: Output<String>? = null

    private var dataSetMappingName: Output<String>? = null

    private var filePath: Output<String>? = null

    private var fileSystem: Output<String>? = null

    private var kind: Output<String>? = null

    private var outputType: Output<Either<String, OutputType>>? = null

    private var resourceGroup: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var shareSubscriptionName: Output<String>? = null

    private var storageAccountName: Output<String>? = null

    private var subscriptionId: Output<String>? = null

    /**
     * @param value The name of the share account.
     */
    @JvmName("lucqvtfhjdkycoch")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The id of the source data set.
     */
    @JvmName("hyydnbgbkidmgakl")
    public suspend fun dataSetId(`value`: Output<String>) {
        this.dataSetId = value
    }

    /**
     * @param value The name of the data set mapping to be created.
     */
    @JvmName("fkjimrjomtdehkix")
    public suspend fun dataSetMappingName(`value`: Output<String>) {
        this.dataSetMappingName = value
    }

    /**
     * @param value File path within the file system.
     */
    @JvmName("ivjuscihaviflfey")
    public suspend fun filePath(`value`: Output<String>) {
        this.filePath = value
    }

    /**
     * @param value File system to which the file belongs.
     */
    @JvmName("aoayqvlaunqmadhe")
    public suspend fun fileSystem(`value`: Output<String>) {
        this.fileSystem = value
    }

    /**
     * @param value Kind of data set mapping.
     * Expected value is 'AdlsGen2File'.
     */
    @JvmName("rxicxhalncbcwdul")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Type of output file
     */
    @JvmName("jmaosihmrdgutkoq")
    public suspend fun outputType(`value`: Output<Either<String, OutputType>>) {
        this.outputType = value
    }

    /**
     * @param value Resource group of storage account.
     */
    @JvmName("nlauwnmslfefjxwm")
    public suspend fun resourceGroup(`value`: Output<String>) {
        this.resourceGroup = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("phgcttocwbtwnlxh")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the share subscription which will hold the data set sink.
     */
    @JvmName("fufdbnrpqmpabwmd")
    public suspend fun shareSubscriptionName(`value`: Output<String>) {
        this.shareSubscriptionName = value
    }

    /**
     * @param value Storage account name of the source data set.
     */
    @JvmName("hashbxfgctpguyfb")
    public suspend fun storageAccountName(`value`: Output<String>) {
        this.storageAccountName = value
    }

    /**
     * @param value Subscription id of storage account.
     */
    @JvmName("dxjgbydbtqlwxvvu")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value The name of the share account.
     */
    @JvmName("dtunpcypkrlofkpl")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The id of the source data set.
     */
    @JvmName("pherpcrulputsrqv")
    public suspend fun dataSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSetId = mapped
    }

    /**
     * @param value The name of the data set mapping to be created.
     */
    @JvmName("mynspmkevinbjjac")
    public suspend fun dataSetMappingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSetMappingName = mapped
    }

    /**
     * @param value File path within the file system.
     */
    @JvmName("guxahunbvqfdrmyw")
    public suspend fun filePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filePath = mapped
    }

    /**
     * @param value File system to which the file belongs.
     */
    @JvmName("iytdltffdgtipgaf")
    public suspend fun fileSystem(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystem = mapped
    }

    /**
     * @param value Kind of data set mapping.
     * Expected value is 'AdlsGen2File'.
     */
    @JvmName("jtyjjvqgkfbotidg")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Type of output file
     */
    @JvmName("vejayhhpuwbculvb")
    public suspend fun outputType(`value`: Either<String, OutputType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputType = mapped
    }

    /**
     * @param value Type of output file
     */
    @JvmName("qkeagpyhbgkcnvmd")
    public fun outputType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OutputType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputType = mapped
    }

    /**
     * @param value Type of output file
     */
    @JvmName("lsedhpqnqmphdnpd")
    public fun outputType(`value`: OutputType) {
        val toBeMapped = Either.ofRight<String, OutputType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputType = mapped
    }

    /**
     * @param value Resource group of storage account.
     */
    @JvmName("nkanritcplvqnasd")
    public suspend fun resourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroup = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("ypyyvdcqgvjqrqtp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the share subscription which will hold the data set sink.
     */
    @JvmName("ougpjrcjxiawgiwf")
    public suspend fun shareSubscriptionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shareSubscriptionName = mapped
    }

    /**
     * @param value Storage account name of the source data set.
     */
    @JvmName("oplalocobcdflkue")
    public suspend fun storageAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountName = mapped
    }

    /**
     * @param value Subscription id of storage account.
     */
    @JvmName("yfhnyslddnhddplx")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    internal fun build(): ADLSGen2FileDataSetMappingArgs = ADLSGen2FileDataSetMappingArgs(
        accountName = accountName,
        dataSetId = dataSetId,
        dataSetMappingName = dataSetMappingName,
        filePath = filePath,
        fileSystem = fileSystem,
        kind = kind,
        outputType = outputType,
        resourceGroup = resourceGroup,
        resourceGroupName = resourceGroupName,
        shareSubscriptionName = shareSubscriptionName,
        storageAccountName = storageAccountName,
        subscriptionId = subscriptionId,
    )
}
