@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin

import com.pulumi.azurenative.datashare.ADLSGen2FolderDataSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An ADLS Gen 2 folder data set.
 * Azure REST API version: 2021-08-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * ## Example Usage
 * ### DataSets_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var adlsGen2FolderDataSet = new AzureNative.DataShare.ADLSGen2FolderDataSet("adlsGen2FolderDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewADLSGen2FolderDataSet(ctx, "adlsGen2FolderDataSet", &datashare.ADLSGen2FolderDataSetArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			DataSetName:       pulumi.String("Dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.ADLSGen2FolderDataSet;
 * import com.pulumi.azurenative.datashare.ADLSGen2FolderDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var adlsGen2FolderDataSet = new ADLSGen2FolderDataSet("adlsGen2FolderDataSet", ADLSGen2FolderDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_KustoCluster_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var adlsGen2FolderDataSet = new AzureNative.DataShare.ADLSGen2FolderDataSet("adlsGen2FolderDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewADLSGen2FolderDataSet(ctx, "adlsGen2FolderDataSet", &datashare.ADLSGen2FolderDataSetArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			DataSetName:       pulumi.String("Dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.ADLSGen2FolderDataSet;
 * import com.pulumi.azurenative.datashare.ADLSGen2FolderDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var adlsGen2FolderDataSet = new ADLSGen2FolderDataSet("adlsGen2FolderDataSet", ADLSGen2FolderDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_KustoDatabase_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var adlsGen2FolderDataSet = new AzureNative.DataShare.ADLSGen2FolderDataSet("adlsGen2FolderDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewADLSGen2FolderDataSet(ctx, "adlsGen2FolderDataSet", &datashare.ADLSGen2FolderDataSetArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			DataSetName:       pulumi.String("Dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.ADLSGen2FolderDataSet;
 * import com.pulumi.azurenative.datashare.ADLSGen2FolderDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var adlsGen2FolderDataSet = new ADLSGen2FolderDataSet("adlsGen2FolderDataSet", ADLSGen2FolderDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_KustoTable_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var adlsGen2FolderDataSet = new AzureNative.DataShare.ADLSGen2FolderDataSet("adlsGen2FolderDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewADLSGen2FolderDataSet(ctx, "adlsGen2FolderDataSet", &datashare.ADLSGen2FolderDataSetArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			DataSetName:       pulumi.String("Dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.ADLSGen2FolderDataSet;
 * import com.pulumi.azurenative.datashare.ADLSGen2FolderDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var adlsGen2FolderDataSet = new ADLSGen2FolderDataSet("adlsGen2FolderDataSet", ADLSGen2FolderDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_SqlDBTable_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var adlsGen2FolderDataSet = new AzureNative.DataShare.ADLSGen2FolderDataSet("adlsGen2FolderDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewADLSGen2FolderDataSet(ctx, "adlsGen2FolderDataSet", &datashare.ADLSGen2FolderDataSetArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			DataSetName:       pulumi.String("Dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.ADLSGen2FolderDataSet;
 * import com.pulumi.azurenative.datashare.ADLSGen2FolderDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var adlsGen2FolderDataSet = new ADLSGen2FolderDataSet("adlsGen2FolderDataSet", ADLSGen2FolderDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_SqlDWTable_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var adlsGen2FolderDataSet = new AzureNative.DataShare.ADLSGen2FolderDataSet("adlsGen2FolderDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewADLSGen2FolderDataSet(ctx, "adlsGen2FolderDataSet", &datashare.ADLSGen2FolderDataSetArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			DataSetName:       pulumi.String("Dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.ADLSGen2FolderDataSet;
 * import com.pulumi.azurenative.datashare.ADLSGen2FolderDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var adlsGen2FolderDataSet = new ADLSGen2FolderDataSet("adlsGen2FolderDataSet", ADLSGen2FolderDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_SynapseWorkspaceSqlPoolTable_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var adlsGen2FolderDataSet = new AzureNative.DataShare.ADLSGen2FolderDataSet("adlsGen2FolderDataSet", new()
 *     {
 *         AccountName = "sourceAccount",
 *         DataSetName = "dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewADLSGen2FolderDataSet(ctx, "adlsGen2FolderDataSet", &datashare.ADLSGen2FolderDataSetArgs{
 * 			AccountName:       pulumi.String("sourceAccount"),
 * 			DataSetName:       pulumi.String("dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.ADLSGen2FolderDataSet;
 * import com.pulumi.azurenative.datashare.ADLSGen2FolderDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var adlsGen2FolderDataSet = new ADLSGen2FolderDataSet("adlsGen2FolderDataSet", ADLSGen2FolderDataSetArgs.builder()
 *             .accountName("sourceAccount")
 *             .dataSetName("dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("share1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datashare:ADLSGen2FolderDataSet dataset1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shares/{shareName}/dataSets/{dataSetName}
 * ```
 * @property accountName The name of the share account.
 * @property dataSetName The name of the dataSet.
 * @property fileSystem File system to which the folder belongs.
 * @property folderPath Folder path within the file system.
 * @property kind Kind of data set.
 * Expected value is 'AdlsGen2Folder'.
 * @property resourceGroup Resource group of storage account
 * @property resourceGroupName The resource group name.
 * @property shareName The name of the share to add the data set to.
 * @property storageAccountName Storage account name of the source data set
 * @property subscriptionId Subscription id of storage account
 */
public data class ADLSGen2FolderDataSetArgs(
    public val accountName: Output<String>? = null,
    public val dataSetName: Output<String>? = null,
    public val fileSystem: Output<String>? = null,
    public val folderPath: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val resourceGroup: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val shareName: Output<String>? = null,
    public val storageAccountName: Output<String>? = null,
    public val subscriptionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datashare.ADLSGen2FolderDataSetArgs> {
    override fun toJava(): com.pulumi.azurenative.datashare.ADLSGen2FolderDataSetArgs =
        com.pulumi.azurenative.datashare.ADLSGen2FolderDataSetArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .dataSetName(dataSetName?.applyValue({ args0 -> args0 }))
            .fileSystem(fileSystem?.applyValue({ args0 -> args0 }))
            .folderPath(folderPath?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .resourceGroup(resourceGroup?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .shareName(shareName?.applyValue({ args0 -> args0 }))
            .storageAccountName(storageAccountName?.applyValue({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ADLSGen2FolderDataSetArgs].
 */
@PulumiTagMarker
public class ADLSGen2FolderDataSetArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var dataSetName: Output<String>? = null

    private var fileSystem: Output<String>? = null

    private var folderPath: Output<String>? = null

    private var kind: Output<String>? = null

    private var resourceGroup: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var shareName: Output<String>? = null

    private var storageAccountName: Output<String>? = null

    private var subscriptionId: Output<String>? = null

    /**
     * @param value The name of the share account.
     */
    @JvmName("qbbcgovfqlvvfuws")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The name of the dataSet.
     */
    @JvmName("mkxvtvrvvyiroogl")
    public suspend fun dataSetName(`value`: Output<String>) {
        this.dataSetName = value
    }

    /**
     * @param value File system to which the folder belongs.
     */
    @JvmName("estnfcuxiygucsms")
    public suspend fun fileSystem(`value`: Output<String>) {
        this.fileSystem = value
    }

    /**
     * @param value Folder path within the file system.
     */
    @JvmName("gagkggovyfeycdxf")
    public suspend fun folderPath(`value`: Output<String>) {
        this.folderPath = value
    }

    /**
     * @param value Kind of data set.
     * Expected value is 'AdlsGen2Folder'.
     */
    @JvmName("denlghksnupjroom")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Resource group of storage account
     */
    @JvmName("qfqueeohbbipiupo")
    public suspend fun resourceGroup(`value`: Output<String>) {
        this.resourceGroup = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("nlgbrawjqxsgcdew")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the share to add the data set to.
     */
    @JvmName("fnatvojhigmyknni")
    public suspend fun shareName(`value`: Output<String>) {
        this.shareName = value
    }

    /**
     * @param value Storage account name of the source data set
     */
    @JvmName("huelenkbdptrpsmv")
    public suspend fun storageAccountName(`value`: Output<String>) {
        this.storageAccountName = value
    }

    /**
     * @param value Subscription id of storage account
     */
    @JvmName("chwyebpofyjkeiuk")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value The name of the share account.
     */
    @JvmName("ckpcqerfceniesdv")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The name of the dataSet.
     */
    @JvmName("jalupdanvomgswqf")
    public suspend fun dataSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSetName = mapped
    }

    /**
     * @param value File system to which the folder belongs.
     */
    @JvmName("denwpouaxudqweny")
    public suspend fun fileSystem(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystem = mapped
    }

    /**
     * @param value Folder path within the file system.
     */
    @JvmName("kqabgvcwokxqmsuy")
    public suspend fun folderPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.folderPath = mapped
    }

    /**
     * @param value Kind of data set.
     * Expected value is 'AdlsGen2Folder'.
     */
    @JvmName("hkajlrwkqatswiyu")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Resource group of storage account
     */
    @JvmName("lnogvoyqiisfsqet")
    public suspend fun resourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroup = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("ighjroyeuxtyjgnq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the share to add the data set to.
     */
    @JvmName("gglkrdbuqegdjben")
    public suspend fun shareName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shareName = mapped
    }

    /**
     * @param value Storage account name of the source data set
     */
    @JvmName("ejiisoxchhflvmsm")
    public suspend fun storageAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountName = mapped
    }

    /**
     * @param value Subscription id of storage account
     */
    @JvmName("leqolkmfmiyldaho")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    internal fun build(): ADLSGen2FolderDataSetArgs = ADLSGen2FolderDataSetArgs(
        accountName = accountName,
        dataSetName = dataSetName,
        fileSystem = fileSystem,
        folderPath = folderPath,
        kind = kind,
        resourceGroup = resourceGroup,
        resourceGroupName = resourceGroupName,
        shareName = shareName,
        storageAccountName = storageAccountName,
        subscriptionId = subscriptionId,
    )
}
