@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin

import com.pulumi.azurenative.datashare.BlobDataSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An Azure storage blob data set.
 * Azure REST API version: 2021-08-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * ## Example Usage
 * ### DataSets_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobDataSet = new AzureNative.DataShare.BlobDataSet("blobDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         ContainerName = "C1",
 *         DataSetName = "Dataset1",
 *         FilePath = "file21",
 *         Kind = "Blob",
 *         ResourceGroup = "SampleResourceGroup",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *         StorageAccountName = "storage2",
 *         SubscriptionId = "433a8dfd-e5d5-4e77-ad86-90acdc75eb1a",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewBlobDataSet(ctx, "blobDataSet", &datashare.BlobDataSetArgs{
 * 			AccountName:        pulumi.String("Account1"),
 * 			ContainerName:      pulumi.String("C1"),
 * 			DataSetName:        pulumi.String("Dataset1"),
 * 			FilePath:           pulumi.String("file21"),
 * 			Kind:               pulumi.String("Blob"),
 * 			ResourceGroup:      pulumi.String("SampleResourceGroup"),
 * 			ResourceGroupName:  pulumi.String("SampleResourceGroup"),
 * 			ShareName:          pulumi.String("Share1"),
 * 			StorageAccountName: pulumi.String("storage2"),
 * 			SubscriptionId:     pulumi.String("433a8dfd-e5d5-4e77-ad86-90acdc75eb1a"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.BlobDataSet;
 * import com.pulumi.azurenative.datashare.BlobDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobDataSet = new BlobDataSet("blobDataSet", BlobDataSetArgs.builder()
 *             .accountName("Account1")
 *             .containerName("C1")
 *             .dataSetName("Dataset1")
 *             .filePath("file21")
 *             .kind("Blob")
 *             .resourceGroup("SampleResourceGroup")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .storageAccountName("storage2")
 *             .subscriptionId("433a8dfd-e5d5-4e77-ad86-90acdc75eb1a")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_KustoCluster_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobDataSet = new AzureNative.DataShare.BlobDataSet("blobDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewBlobDataSet(ctx, "blobDataSet", &datashare.BlobDataSetArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			DataSetName:       pulumi.String("Dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.BlobDataSet;
 * import com.pulumi.azurenative.datashare.BlobDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobDataSet = new BlobDataSet("blobDataSet", BlobDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_KustoDatabase_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobDataSet = new AzureNative.DataShare.BlobDataSet("blobDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewBlobDataSet(ctx, "blobDataSet", &datashare.BlobDataSetArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			DataSetName:       pulumi.String("Dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.BlobDataSet;
 * import com.pulumi.azurenative.datashare.BlobDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobDataSet = new BlobDataSet("blobDataSet", BlobDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_KustoTable_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobDataSet = new AzureNative.DataShare.BlobDataSet("blobDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewBlobDataSet(ctx, "blobDataSet", &datashare.BlobDataSetArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			DataSetName:       pulumi.String("Dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.BlobDataSet;
 * import com.pulumi.azurenative.datashare.BlobDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobDataSet = new BlobDataSet("blobDataSet", BlobDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_SqlDBTable_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobDataSet = new AzureNative.DataShare.BlobDataSet("blobDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewBlobDataSet(ctx, "blobDataSet", &datashare.BlobDataSetArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			DataSetName:       pulumi.String("Dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.BlobDataSet;
 * import com.pulumi.azurenative.datashare.BlobDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobDataSet = new BlobDataSet("blobDataSet", BlobDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_SqlDWTable_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobDataSet = new AzureNative.DataShare.BlobDataSet("blobDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewBlobDataSet(ctx, "blobDataSet", &datashare.BlobDataSetArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			DataSetName:       pulumi.String("Dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.BlobDataSet;
 * import com.pulumi.azurenative.datashare.BlobDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobDataSet = new BlobDataSet("blobDataSet", BlobDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_SynapseWorkspaceSqlPoolTable_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobDataSet = new AzureNative.DataShare.BlobDataSet("blobDataSet", new()
 *     {
 *         AccountName = "sourceAccount",
 *         DataSetName = "dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewBlobDataSet(ctx, "blobDataSet", &datashare.BlobDataSetArgs{
 * 			AccountName:       pulumi.String("sourceAccount"),
 * 			DataSetName:       pulumi.String("dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.BlobDataSet;
 * import com.pulumi.azurenative.datashare.BlobDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobDataSet = new BlobDataSet("blobDataSet", BlobDataSetArgs.builder()
 *             .accountName("sourceAccount")
 *             .dataSetName("dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("share1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datashare:BlobDataSet dataset1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shares/{shareName}/dataSets/{dataSetName}
 * ```
 * @property accountName The name of the share account.
 * @property containerName Container that has the file path.
 * @property dataSetName The name of the dataSet.
 * @property filePath File path within the source data set
 * @property kind Kind of data set.
 * Expected value is 'Blob'.
 * @property resourceGroup Resource group of storage account
 * @property resourceGroupName The resource group name.
 * @property shareName The name of the share to add the data set to.
 * @property storageAccountName Storage account name of the source data set
 * @property subscriptionId Subscription id of storage account
 */
public data class BlobDataSetArgs(
    public val accountName: Output<String>? = null,
    public val containerName: Output<String>? = null,
    public val dataSetName: Output<String>? = null,
    public val filePath: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val resourceGroup: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val shareName: Output<String>? = null,
    public val storageAccountName: Output<String>? = null,
    public val subscriptionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datashare.BlobDataSetArgs> {
    override fun toJava(): com.pulumi.azurenative.datashare.BlobDataSetArgs =
        com.pulumi.azurenative.datashare.BlobDataSetArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .containerName(containerName?.applyValue({ args0 -> args0 }))
            .dataSetName(dataSetName?.applyValue({ args0 -> args0 }))
            .filePath(filePath?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .resourceGroup(resourceGroup?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .shareName(shareName?.applyValue({ args0 -> args0 }))
            .storageAccountName(storageAccountName?.applyValue({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BlobDataSetArgs].
 */
@PulumiTagMarker
public class BlobDataSetArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var containerName: Output<String>? = null

    private var dataSetName: Output<String>? = null

    private var filePath: Output<String>? = null

    private var kind: Output<String>? = null

    private var resourceGroup: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var shareName: Output<String>? = null

    private var storageAccountName: Output<String>? = null

    private var subscriptionId: Output<String>? = null

    /**
     * @param value The name of the share account.
     */
    @JvmName("uicxkmvrwpcnhbvb")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Container that has the file path.
     */
    @JvmName("pormeliekbktlfnv")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value The name of the dataSet.
     */
    @JvmName("hwyhqmgjlstjphgc")
    public suspend fun dataSetName(`value`: Output<String>) {
        this.dataSetName = value
    }

    /**
     * @param value File path within the source data set
     */
    @JvmName("wikimriyxmrsruqx")
    public suspend fun filePath(`value`: Output<String>) {
        this.filePath = value
    }

    /**
     * @param value Kind of data set.
     * Expected value is 'Blob'.
     */
    @JvmName("btmdythjbybkbyeo")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Resource group of storage account
     */
    @JvmName("opxuikbhytfolbeg")
    public suspend fun resourceGroup(`value`: Output<String>) {
        this.resourceGroup = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("moetneypegourmxd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the share to add the data set to.
     */
    @JvmName("tkfgbdtaqpaaahuj")
    public suspend fun shareName(`value`: Output<String>) {
        this.shareName = value
    }

    /**
     * @param value Storage account name of the source data set
     */
    @JvmName("hiaiqkjmcyefsoka")
    public suspend fun storageAccountName(`value`: Output<String>) {
        this.storageAccountName = value
    }

    /**
     * @param value Subscription id of storage account
     */
    @JvmName("wqdmoempntpocudr")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value The name of the share account.
     */
    @JvmName("lpqdbhofpkhmgnwl")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Container that has the file path.
     */
    @JvmName("pkwvnonqjyfdopgj")
    public suspend fun containerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value The name of the dataSet.
     */
    @JvmName("dwucopnjqbonmrkl")
    public suspend fun dataSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSetName = mapped
    }

    /**
     * @param value File path within the source data set
     */
    @JvmName("ykmevfrfjodeadij")
    public suspend fun filePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filePath = mapped
    }

    /**
     * @param value Kind of data set.
     * Expected value is 'Blob'.
     */
    @JvmName("scougxwspasorysr")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Resource group of storage account
     */
    @JvmName("urimoxwdjpblmrad")
    public suspend fun resourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroup = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("rxabwpmipebrdeug")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the share to add the data set to.
     */
    @JvmName("aqabyevkcqiorotb")
    public suspend fun shareName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shareName = mapped
    }

    /**
     * @param value Storage account name of the source data set
     */
    @JvmName("veahguucrtdtjjky")
    public suspend fun storageAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountName = mapped
    }

    /**
     * @param value Subscription id of storage account
     */
    @JvmName("ylamvegxtpitwmta")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    internal fun build(): BlobDataSetArgs = BlobDataSetArgs(
        accountName = accountName,
        containerName = containerName,
        dataSetName = dataSetName,
        filePath = filePath,
        kind = kind,
        resourceGroup = resourceGroup,
        resourceGroupName = resourceGroupName,
        shareName = shareName,
        storageAccountName = storageAccountName,
        subscriptionId = subscriptionId,
    )
}
