@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin

import com.pulumi.azurenative.datashare.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.datashare.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ScheduledTrigger].
 */
@PulumiTagMarker
public class ScheduledTriggerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ScheduledTriggerArgs = ScheduledTriggerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ScheduledTriggerArgsBuilder.() -> Unit) {
        val builder = ScheduledTriggerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ScheduledTrigger {
        val builtJavaResource =
            com.pulumi.azurenative.datashare.ScheduledTrigger(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ScheduledTrigger(builtJavaResource)
    }
}

/**
 * A type of trigger based on schedule
 * Azure REST API version: 2021-08-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * ## Example Usage
 * ### Triggers_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scheduledTrigger = new AzureNative.DataShare.ScheduledTrigger("scheduledTrigger", new()
 *     {
 *         AccountName = "Account1",
 *         Kind = "ScheduleBased",
 *         RecurrenceInterval = "Day",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareSubscriptionName = "ShareSubscription1",
 *         SynchronizationMode = "Incremental",
 *         SynchronizationTime = "2018-11-14T04:47:52.9614956Z",
 *         TriggerName = "Trigger1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewScheduledTrigger(ctx, "scheduledTrigger", &datashare.ScheduledTriggerArgs{
 * 			AccountName:           pulumi.String("Account1"),
 * 			Kind:                  pulumi.String("ScheduleBased"),
 * 			RecurrenceInterval:    pulumi.String("Day"),
 * 			ResourceGroupName:     pulumi.String("SampleResourceGroup"),
 * 			ShareSubscriptionName: pulumi.String("ShareSubscription1"),
 * 			SynchronizationMode:   pulumi.String("Incremental"),
 * 			SynchronizationTime:   pulumi.String("2018-11-14T04:47:52.9614956Z"),
 * 			TriggerName:           pulumi.String("Trigger1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.ScheduledTrigger;
 * import com.pulumi.azurenative.datashare.ScheduledTriggerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scheduledTrigger = new ScheduledTrigger("scheduledTrigger", ScheduledTriggerArgs.builder()
 *             .accountName("Account1")
 *             .kind("ScheduleBased")
 *             .recurrenceInterval("Day")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .synchronizationMode("Incremental")
 *             .synchronizationTime("2018-11-14T04:47:52.9614956Z")
 *             .triggerName("Trigger1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datashare:ScheduledTrigger Trigger1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}/triggers/{triggerName}
 * ```
 */
public class ScheduledTrigger internal constructor(
    override val javaResource: com.pulumi.azurenative.datashare.ScheduledTrigger,
) : KotlinCustomResource(javaResource, ScheduledTriggerMapper) {
    /**
     * Time at which the trigger was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * Kind of synchronization on trigger.
     * Expected value is 'ScheduleBased'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * Name of the azure resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets the provisioning state
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Recurrence Interval
     */
    public val recurrenceInterval: Output<String>
        get() = javaResource.recurrenceInterval().applyValue({ args0 -> args0 })

    /**
     * Synchronization mode
     */
    public val synchronizationMode: Output<String>?
        get() = javaResource.synchronizationMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Synchronization time
     */
    public val synchronizationTime: Output<String>
        get() = javaResource.synchronizationTime().applyValue({ args0 -> args0 })

    /**
     * System Data of the Azure resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Gets the trigger state
     */
    public val triggerStatus: Output<String>
        get() = javaResource.triggerStatus().applyValue({ args0 -> args0 })

    /**
     * Type of the azure resource
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Name of the user who created the trigger.
     */
    public val userName: Output<String>
        get() = javaResource.userName().applyValue({ args0 -> args0 })
}

public object ScheduledTriggerMapper : ResourceMapper<ScheduledTrigger> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datashare.ScheduledTrigger::class == javaResource::class

    override fun map(javaResource: Resource): ScheduledTrigger = ScheduledTrigger(
        javaResource as
            com.pulumi.azurenative.datashare.ScheduledTrigger,
    )
}

/**
 * @see [ScheduledTrigger].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ScheduledTrigger].
 */
public suspend fun scheduledTrigger(
    name: String,
    block: suspend ScheduledTriggerResourceBuilder.() -> Unit,
): ScheduledTrigger {
    val builder = ScheduledTriggerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ScheduledTrigger].
 * @param name The _unique_ name of the resulting resource.
 */
public fun scheduledTrigger(name: String): ScheduledTrigger {
    val builder = ScheduledTriggerResourceBuilder()
    builder.name(name)
    return builder.build()
}
