@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin

import com.pulumi.azurenative.datashare.ShareArgs.builder
import com.pulumi.azurenative.datashare.kotlin.enums.ShareKind
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A share data transfer object.
 * Azure REST API version: 2021-08-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * ## Example Usage
 * ### Shares_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var share = new AzureNative.DataShare.Share("share", new()
 *     {
 *         AccountName = "Account1",
 *         Description = "share description",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareKind = "CopyBased",
 *         ShareName = "Share1",
 *         Terms = "Confidential",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewShare(ctx, "share", &datashare.ShareArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			Description:       pulumi.String("share description"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareKind:         pulumi.String("CopyBased"),
 * 			ShareName:         pulumi.String("Share1"),
 * 			Terms:             pulumi.String("Confidential"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.Share;
 * import com.pulumi.azurenative.datashare.ShareArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var share = new Share("share", ShareArgs.builder()
 *             .accountName("Account1")
 *             .description("share description")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareKind("CopyBased")
 *             .shareName("Share1")
 *             .terms("Confidential")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datashare:Share Share1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shares/{shareName}
 * ```
 * @property accountName The name of the share account.
 * @property description Share description.
 * @property resourceGroupName The resource group name.
 * @property shareKind Share kind.
 * @property shareName The name of the share.
 * @property terms Share terms.
 */
public data class ShareArgs(
    public val accountName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val shareKind: Output<Either<String, ShareKind>>? = null,
    public val shareName: Output<String>? = null,
    public val terms: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datashare.ShareArgs> {
    override fun toJava(): com.pulumi.azurenative.datashare.ShareArgs =
        com.pulumi.azurenative.datashare.ShareArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .shareKind(
                shareKind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .shareName(shareName?.applyValue({ args0 -> args0 }))
            .terms(terms?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ShareArgs].
 */
@PulumiTagMarker
public class ShareArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var description: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var shareKind: Output<Either<String, ShareKind>>? = null

    private var shareName: Output<String>? = null

    private var terms: Output<String>? = null

    /**
     * @param value The name of the share account.
     */
    @JvmName("aqjlrbvbriffvvrx")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Share description.
     */
    @JvmName("ljacakiypolrkinb")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("vjdncbgsqicpgcxh")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Share kind.
     */
    @JvmName("dbdhgboeteefybtt")
    public suspend fun shareKind(`value`: Output<Either<String, ShareKind>>) {
        this.shareKind = value
    }

    /**
     * @param value The name of the share.
     */
    @JvmName("qjyotlmgqyaejgyi")
    public suspend fun shareName(`value`: Output<String>) {
        this.shareName = value
    }

    /**
     * @param value Share terms.
     */
    @JvmName("gdreivkpvniuatlx")
    public suspend fun terms(`value`: Output<String>) {
        this.terms = value
    }

    /**
     * @param value The name of the share account.
     */
    @JvmName("mlelivxrywfoavsf")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Share description.
     */
    @JvmName("aqobpcjqlonbowwd")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("qvlmvgyonwmilsii")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Share kind.
     */
    @JvmName("fsmudbiqxldwrtrc")
    public suspend fun shareKind(`value`: Either<String, ShareKind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shareKind = mapped
    }

    /**
     * @param value Share kind.
     */
    @JvmName("nwrgovsvuqtotnip")
    public fun shareKind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ShareKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.shareKind = mapped
    }

    /**
     * @param value Share kind.
     */
    @JvmName("xtjbvbvlepmufaoo")
    public fun shareKind(`value`: ShareKind) {
        val toBeMapped = Either.ofRight<String, ShareKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.shareKind = mapped
    }

    /**
     * @param value The name of the share.
     */
    @JvmName("todmablelnwqomlt")
    public suspend fun shareName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shareName = mapped
    }

    /**
     * @param value Share terms.
     */
    @JvmName("kehyhwpqudiehgjg")
    public suspend fun terms(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.terms = mapped
    }

    internal fun build(): ShareArgs = ShareArgs(
        accountName = accountName,
        description = description,
        resourceGroupName = resourceGroupName,
        shareKind = shareKind,
        shareName = shareName,
        terms = terms,
    )
}
