@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin

import com.pulumi.azurenative.datashare.SqlDWTableDataSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A SQL DW table data set.
 * Azure REST API version: 2021-08-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * ## Example Usage
 * ### DataSets_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlDWTableDataSet = new AzureNative.DataShare.SqlDWTableDataSet("sqlDWTableDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewSqlDWTableDataSet(ctx, "sqlDWTableDataSet", &datashare.SqlDWTableDataSetArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			DataSetName:       pulumi.String("Dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.SqlDWTableDataSet;
 * import com.pulumi.azurenative.datashare.SqlDWTableDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlDWTableDataSet = new SqlDWTableDataSet("sqlDWTableDataSet", SqlDWTableDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_KustoCluster_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlDWTableDataSet = new AzureNative.DataShare.SqlDWTableDataSet("sqlDWTableDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewSqlDWTableDataSet(ctx, "sqlDWTableDataSet", &datashare.SqlDWTableDataSetArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			DataSetName:       pulumi.String("Dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.SqlDWTableDataSet;
 * import com.pulumi.azurenative.datashare.SqlDWTableDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlDWTableDataSet = new SqlDWTableDataSet("sqlDWTableDataSet", SqlDWTableDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_KustoDatabase_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlDWTableDataSet = new AzureNative.DataShare.SqlDWTableDataSet("sqlDWTableDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewSqlDWTableDataSet(ctx, "sqlDWTableDataSet", &datashare.SqlDWTableDataSetArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			DataSetName:       pulumi.String("Dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.SqlDWTableDataSet;
 * import com.pulumi.azurenative.datashare.SqlDWTableDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlDWTableDataSet = new SqlDWTableDataSet("sqlDWTableDataSet", SqlDWTableDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_KustoTable_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlDWTableDataSet = new AzureNative.DataShare.SqlDWTableDataSet("sqlDWTableDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewSqlDWTableDataSet(ctx, "sqlDWTableDataSet", &datashare.SqlDWTableDataSetArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			DataSetName:       pulumi.String("Dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.SqlDWTableDataSet;
 * import com.pulumi.azurenative.datashare.SqlDWTableDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlDWTableDataSet = new SqlDWTableDataSet("sqlDWTableDataSet", SqlDWTableDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_SqlDBTable_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlDWTableDataSet = new AzureNative.DataShare.SqlDWTableDataSet("sqlDWTableDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewSqlDWTableDataSet(ctx, "sqlDWTableDataSet", &datashare.SqlDWTableDataSetArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			DataSetName:       pulumi.String("Dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.SqlDWTableDataSet;
 * import com.pulumi.azurenative.datashare.SqlDWTableDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlDWTableDataSet = new SqlDWTableDataSet("sqlDWTableDataSet", SqlDWTableDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_SqlDWTable_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlDWTableDataSet = new AzureNative.DataShare.SqlDWTableDataSet("sqlDWTableDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         DataWarehouseName = "DataWarehouse1",
 *         Kind = "SqlDWTable",
 *         ResourceGroupName = "SampleResourceGroup",
 *         SchemaName = "dbo",
 *         ShareName = "Share1",
 *         SqlServerResourceId = "/subscriptions/433a8dfd-e5d5-4e77-ad86-90acdc75eb1a/resourceGroups/SampleResourceGroup/providers/Microsoft.Sql/servers/Server1",
 *         TableName = "Table1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewSqlDWTableDataSet(ctx, "sqlDWTableDataSet", &datashare.SqlDWTableDataSetArgs{
 * 			AccountName:         pulumi.String("Account1"),
 * 			DataSetName:         pulumi.String("Dataset1"),
 * 			DataWarehouseName:   pulumi.String("DataWarehouse1"),
 * 			Kind:                pulumi.String("SqlDWTable"),
 * 			ResourceGroupName:   pulumi.String("SampleResourceGroup"),
 * 			SchemaName:          pulumi.String("dbo"),
 * 			ShareName:           pulumi.String("Share1"),
 * 			SqlServerResourceId: pulumi.String("/subscriptions/433a8dfd-e5d5-4e77-ad86-90acdc75eb1a/resourceGroups/SampleResourceGroup/providers/Microsoft.Sql/servers/Server1"),
 * 			TableName:           pulumi.String("Table1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.SqlDWTableDataSet;
 * import com.pulumi.azurenative.datashare.SqlDWTableDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlDWTableDataSet = new SqlDWTableDataSet("sqlDWTableDataSet", SqlDWTableDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .dataWarehouseName("DataWarehouse1")
 *             .kind("SqlDWTable")
 *             .resourceGroupName("SampleResourceGroup")
 *             .schemaName("dbo")
 *             .shareName("Share1")
 *             .sqlServerResourceId("/subscriptions/433a8dfd-e5d5-4e77-ad86-90acdc75eb1a/resourceGroups/SampleResourceGroup/providers/Microsoft.Sql/servers/Server1")
 *             .tableName("Table1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_SynapseWorkspaceSqlPoolTable_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlDWTableDataSet = new AzureNative.DataShare.SqlDWTableDataSet("sqlDWTableDataSet", new()
 *     {
 *         AccountName = "sourceAccount",
 *         DataSetName = "dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewSqlDWTableDataSet(ctx, "sqlDWTableDataSet", &datashare.SqlDWTableDataSetArgs{
 * 			AccountName:       pulumi.String("sourceAccount"),
 * 			DataSetName:       pulumi.String("dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.SqlDWTableDataSet;
 * import com.pulumi.azurenative.datashare.SqlDWTableDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlDWTableDataSet = new SqlDWTableDataSet("sqlDWTableDataSet", SqlDWTableDataSetArgs.builder()
 *             .accountName("sourceAccount")
 *             .dataSetName("dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("share1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datashare:SqlDWTableDataSet dataset1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shares/{shareName}/dataSets/{dataSetName}
 * ```
 * @property accountName The name of the share account.
 * @property dataSetName The name of the dataSet.
 * @property dataWarehouseName DataWarehouse name of the source data set
 * @property kind Kind of data set.
 * Expected value is 'SqlDWTable'.
 * @property resourceGroupName The resource group name.
 * @property schemaName Schema of the table. Default value is dbo.
 * @property shareName The name of the share to add the data set to.
 * @property sqlServerResourceId Resource id of SQL server
 * @property tableName SQL DW table name.
 */
public data class SqlDWTableDataSetArgs(
    public val accountName: Output<String>? = null,
    public val dataSetName: Output<String>? = null,
    public val dataWarehouseName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val schemaName: Output<String>? = null,
    public val shareName: Output<String>? = null,
    public val sqlServerResourceId: Output<String>? = null,
    public val tableName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datashare.SqlDWTableDataSetArgs> {
    override fun toJava(): com.pulumi.azurenative.datashare.SqlDWTableDataSetArgs =
        com.pulumi.azurenative.datashare.SqlDWTableDataSetArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .dataSetName(dataSetName?.applyValue({ args0 -> args0 }))
            .dataWarehouseName(dataWarehouseName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .schemaName(schemaName?.applyValue({ args0 -> args0 }))
            .shareName(shareName?.applyValue({ args0 -> args0 }))
            .sqlServerResourceId(sqlServerResourceId?.applyValue({ args0 -> args0 }))
            .tableName(tableName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SqlDWTableDataSetArgs].
 */
@PulumiTagMarker
public class SqlDWTableDataSetArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var dataSetName: Output<String>? = null

    private var dataWarehouseName: Output<String>? = null

    private var kind: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var schemaName: Output<String>? = null

    private var shareName: Output<String>? = null

    private var sqlServerResourceId: Output<String>? = null

    private var tableName: Output<String>? = null

    /**
     * @param value The name of the share account.
     */
    @JvmName("bvtyugjhfuvxmigc")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The name of the dataSet.
     */
    @JvmName("eqjdtkdlslybwype")
    public suspend fun dataSetName(`value`: Output<String>) {
        this.dataSetName = value
    }

    /**
     * @param value DataWarehouse name of the source data set
     */
    @JvmName("amgxohpxfxupihct")
    public suspend fun dataWarehouseName(`value`: Output<String>) {
        this.dataWarehouseName = value
    }

    /**
     * @param value Kind of data set.
     * Expected value is 'SqlDWTable'.
     */
    @JvmName("hgbjgcqtrdwqvbnn")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("eorrgswgqrhycvep")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Schema of the table. Default value is dbo.
     */
    @JvmName("cltpnuuqxrmniwxe")
    public suspend fun schemaName(`value`: Output<String>) {
        this.schemaName = value
    }

    /**
     * @param value The name of the share to add the data set to.
     */
    @JvmName("tufikwhkeismenja")
    public suspend fun shareName(`value`: Output<String>) {
        this.shareName = value
    }

    /**
     * @param value Resource id of SQL server
     */
    @JvmName("buapwytopkpuqepd")
    public suspend fun sqlServerResourceId(`value`: Output<String>) {
        this.sqlServerResourceId = value
    }

    /**
     * @param value SQL DW table name.
     */
    @JvmName("fqoobcefttxobyue")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value The name of the share account.
     */
    @JvmName("gikmtbndlfflevys")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The name of the dataSet.
     */
    @JvmName("ugwqxbhkmqyvdbjh")
    public suspend fun dataSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSetName = mapped
    }

    /**
     * @param value DataWarehouse name of the source data set
     */
    @JvmName("nclyitescbwaoapc")
    public suspend fun dataWarehouseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataWarehouseName = mapped
    }

    /**
     * @param value Kind of data set.
     * Expected value is 'SqlDWTable'.
     */
    @JvmName("lshbdjkpfugfhesr")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("sbhfiftbseceapky")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Schema of the table. Default value is dbo.
     */
    @JvmName("rsnxyvuwxpuudayx")
    public suspend fun schemaName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaName = mapped
    }

    /**
     * @param value The name of the share to add the data set to.
     */
    @JvmName("iyfsxkoiqeucgvxo")
    public suspend fun shareName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shareName = mapped
    }

    /**
     * @param value Resource id of SQL server
     */
    @JvmName("gnaygeraihgkqynu")
    public suspend fun sqlServerResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlServerResourceId = mapped
    }

    /**
     * @param value SQL DW table name.
     */
    @JvmName("fhughkuxclrdoakj")
    public suspend fun tableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    internal fun build(): SqlDWTableDataSetArgs = SqlDWTableDataSetArgs(
        accountName = accountName,
        dataSetName = dataSetName,
        dataWarehouseName = dataWarehouseName,
        kind = kind,
        resourceGroupName = resourceGroupName,
        schemaName = schemaName,
        shareName = shareName,
        sqlServerResourceId = sqlServerResourceId,
        tableName = tableName,
    )
}
