@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin.inputs

import com.pulumi.azurenative.datashare.inputs.GetInvitationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the share account.
 * @property invitationName The name of the invitation.
 * @property resourceGroupName The resource group name.
 * @property shareName The name of the share.
 */
public data class GetInvitationPlainArgs(
    public val accountName: String,
    public val invitationName: String,
    public val resourceGroupName: String,
    public val shareName: String,
) : ConvertibleToJava<com.pulumi.azurenative.datashare.inputs.GetInvitationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.datashare.inputs.GetInvitationPlainArgs =
        com.pulumi.azurenative.datashare.inputs.GetInvitationPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .invitationName(invitationName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .shareName(shareName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInvitationPlainArgs].
 */
@PulumiTagMarker
public class GetInvitationPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var invitationName: String? = null

    private var resourceGroupName: String? = null

    private var shareName: String? = null

    /**
     * @param value The name of the share account.
     */
    @JvmName("dulxcaorvcjbwryq")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the invitation.
     */
    @JvmName("awyvuvgbmhavgbwu")
    public suspend fun invitationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.invitationName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("xngqkiagfwcodvab")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the share.
     */
    @JvmName("uqcqnrusootjldab")
    public suspend fun shareName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.shareName = mapped
    }

    internal fun build(): GetInvitationPlainArgs = GetInvitationPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        invitationName = invitationName ?: throw PulumiNullFieldException("invitationName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        shareName = shareName ?: throw PulumiNullFieldException("shareName"),
    )
}
