@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin.inputs

import com.pulumi.azurenative.datashare.inputs.GetScheduledSynchronizationSettingPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the share account.
 * @property resourceGroupName The resource group name.
 * @property shareName The name of the share.
 * @property synchronizationSettingName The name of the synchronizationSetting.
 */
public data class GetScheduledSynchronizationSettingPlainArgs(
    public val accountName: String,
    public val resourceGroupName: String,
    public val shareName: String,
    public val synchronizationSettingName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.datashare.inputs.GetScheduledSynchronizationSettingPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.datashare.inputs.GetScheduledSynchronizationSettingPlainArgs =
        com.pulumi.azurenative.datashare.inputs.GetScheduledSynchronizationSettingPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .shareName(shareName.let({ args0 -> args0 }))
            .synchronizationSettingName(synchronizationSettingName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetScheduledSynchronizationSettingPlainArgs].
 */
@PulumiTagMarker
public class GetScheduledSynchronizationSettingPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var resourceGroupName: String? = null

    private var shareName: String? = null

    private var synchronizationSettingName: String? = null

    /**
     * @param value The name of the share account.
     */
    @JvmName("xtqywkxiqqagecak")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("eiwaqyufyxeasicx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the share.
     */
    @JvmName("bwbybkwalxvkfudd")
    public suspend fun shareName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.shareName = mapped
    }

    /**
     * @param value The name of the synchronizationSetting.
     */
    @JvmName("emgjmqmrwkgtydjt")
    public suspend fun synchronizationSettingName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.synchronizationSettingName = mapped
    }

    internal fun build(): GetScheduledSynchronizationSettingPlainArgs =
        GetScheduledSynchronizationSettingPlainArgs(
            accountName = accountName ?: throw PulumiNullFieldException("accountName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            shareName = shareName ?: throw PulumiNullFieldException("shareName"),
            synchronizationSettingName = synchronizationSettingName ?: throw
                PulumiNullFieldException("synchronizationSettingName"),
        )
}
