@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin.inputs

import com.pulumi.azurenative.datashare.inputs.GetScheduledTriggerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the share account.
 * @property resourceGroupName The resource group name.
 * @property shareSubscriptionName The name of the shareSubscription.
 * @property triggerName The name of the trigger.
 */
public data class GetScheduledTriggerPlainArgs(
    public val accountName: String,
    public val resourceGroupName: String,
    public val shareSubscriptionName: String,
    public val triggerName: String,
) : ConvertibleToJava<com.pulumi.azurenative.datashare.inputs.GetScheduledTriggerPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.datashare.inputs.GetScheduledTriggerPlainArgs =
        com.pulumi.azurenative.datashare.inputs.GetScheduledTriggerPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .shareSubscriptionName(shareSubscriptionName.let({ args0 -> args0 }))
            .triggerName(triggerName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetScheduledTriggerPlainArgs].
 */
@PulumiTagMarker
public class GetScheduledTriggerPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var resourceGroupName: String? = null

    private var shareSubscriptionName: String? = null

    private var triggerName: String? = null

    /**
     * @param value The name of the share account.
     */
    @JvmName("ulvlgtrslshuysbm")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("sauqmsqfjjdtfelh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the shareSubscription.
     */
    @JvmName("bqrdavkmqfldnmjf")
    public suspend fun shareSubscriptionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.shareSubscriptionName = mapped
    }

    /**
     * @param value The name of the trigger.
     */
    @JvmName("lckyeaqmgcdcefqn")
    public suspend fun triggerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.triggerName = mapped
    }

    internal fun build(): GetScheduledTriggerPlainArgs = GetScheduledTriggerPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        shareSubscriptionName = shareSubscriptionName ?: throw
            PulumiNullFieldException("shareSubscriptionName"),
        triggerName = triggerName ?: throw PulumiNullFieldException("triggerName"),
    )
}
