@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin.inputs

import com.pulumi.azurenative.datashare.inputs.GetSharePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the share account.
 * @property resourceGroupName The resource group name.
 * @property shareName The name of the share to retrieve.
 */
public data class GetSharePlainArgs(
    public val accountName: String,
    public val resourceGroupName: String,
    public val shareName: String,
) : ConvertibleToJava<com.pulumi.azurenative.datashare.inputs.GetSharePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.datashare.inputs.GetSharePlainArgs =
        com.pulumi.azurenative.datashare.inputs.GetSharePlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .shareName(shareName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSharePlainArgs].
 */
@PulumiTagMarker
public class GetSharePlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var resourceGroupName: String? = null

    private var shareName: String? = null

    /**
     * @param value The name of the share account.
     */
    @JvmName("yvhxmnxwbiaiqbam")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("qwbuaffxbuvjptsk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the share to retrieve.
     */
    @JvmName("nltdlbiknsekjaor")
    public suspend fun shareName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.shareName = mapped
    }

    internal fun build(): GetSharePlainArgs = GetSharePlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        shareName = shareName ?: throw PulumiNullFieldException("shareName"),
    )
}
