@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin.inputs

import com.pulumi.azurenative.datashare.inputs.ListShareSubscriptionSourceShareSynchronizationSettingsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the share account.
 * @property resourceGroupName The resource group name.
 * @property shareSubscriptionName The name of the shareSubscription.
 * @property skipToken Continuation token
 */
public data class ListShareSubscriptionSourceShareSynchronizationSettingsPlainArgs(
    public val accountName: String,
    public val resourceGroupName: String,
    public val shareSubscriptionName: String,
    public val skipToken: String? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.datashare.inputs.ListShareSubscriptionSourceShareSynchronizationSettingsPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.datashare.inputs.ListShareSubscriptionSourceShareSynchronizationSettingsPlainArgs =
        com.pulumi.azurenative.datashare.inputs.ListShareSubscriptionSourceShareSynchronizationSettingsPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .shareSubscriptionName(shareSubscriptionName.let({ args0 -> args0 }))
            .skipToken(skipToken?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListShareSubscriptionSourceShareSynchronizationSettingsPlainArgs].
 */
@PulumiTagMarker
public class ListShareSubscriptionSourceShareSynchronizationSettingsPlainArgsBuilder internal
constructor() {
    private var accountName: String? = null

    private var resourceGroupName: String? = null

    private var shareSubscriptionName: String? = null

    private var skipToken: String? = null

    /**
     * @param value The name of the share account.
     */
    @JvmName("pcnpmaeqffajjpsk")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("tivnovtlgbkxvktv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the shareSubscription.
     */
    @JvmName("xrieoahxjlrrkayg")
    public suspend fun shareSubscriptionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.shareSubscriptionName = mapped
    }

    /**
     * @param value Continuation token
     */
    @JvmName("anrttqtisemarrlv")
    public suspend fun skipToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.skipToken = mapped
    }

    internal fun build(): ListShareSubscriptionSourceShareSynchronizationSettingsPlainArgs =
        ListShareSubscriptionSourceShareSynchronizationSettingsPlainArgs(
            accountName = accountName ?: throw PulumiNullFieldException("accountName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            shareSubscriptionName = shareSubscriptionName ?: throw
                PulumiNullFieldException("shareSubscriptionName"),
            skipToken = skipToken,
        )
}
