@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A Blob container data set mapping.
 * @property containerName BLOB Container name.
 * @property dataSetId The id of the source data set.
 * @property dataSetMappingStatus Gets the status of the data set mapping.
 * @property id The resource id of the azure resource
 * @property kind Kind of data set mapping.
 * Expected value is 'Container'.
 * @property name Name of the azure resource
 * @property provisioningState Provisioning state of the data set mapping.
 * @property resourceGroup Resource group of storage account.
 * @property storageAccountName Storage account name of the source data set.
 * @property subscriptionId Subscription id of storage account.
 * @property systemData System Data of the Azure resource.
 * @property type Type of the azure resource
 */
public data class GetBlobContainerDataSetMappingResult(
    public val containerName: String,
    public val dataSetId: String,
    public val dataSetMappingStatus: String,
    public val id: String,
    public val kind: String,
    public val name: String,
    public val provisioningState: String,
    public val resourceGroup: String,
    public val storageAccountName: String,
    public val subscriptionId: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datashare.outputs.GetBlobContainerDataSetMappingResult):
            GetBlobContainerDataSetMappingResult = GetBlobContainerDataSetMappingResult(
            containerName = javaType.containerName(),
            dataSetId = javaType.dataSetId(),
            dataSetMappingStatus = javaType.dataSetMappingStatus(),
            id = javaType.id(),
            kind = javaType.kind(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            resourceGroup = javaType.resourceGroup(),
            storageAccountName = javaType.storageAccountName(),
            subscriptionId = javaType.subscriptionId(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.datashare.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
