@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A type of synchronization setting based on schedule
 * @property createdAt Time at which the synchronization setting was created.
 * @property id The resource id of the azure resource
 * @property kind Kind of synchronization setting.
 * Expected value is 'ScheduleBased'.
 * @property name Name of the azure resource
 * @property provisioningState Gets or sets the provisioning state
 * @property recurrenceInterval Recurrence Interval
 * @property synchronizationTime Synchronization time
 * @property systemData System Data of the Azure resource.
 * @property type Type of the azure resource
 * @property userName Name of the user who created the synchronization setting.
 */
public data class GetScheduledSynchronizationSettingResult(
    public val createdAt: String,
    public val id: String,
    public val kind: String,
    public val name: String,
    public val provisioningState: String,
    public val recurrenceInterval: String,
    public val synchronizationTime: String,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val userName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datashare.outputs.GetScheduledSynchronizationSettingResult):
            GetScheduledSynchronizationSettingResult = GetScheduledSynchronizationSettingResult(
            createdAt = javaType.createdAt(),
            id = javaType.id(),
            kind = javaType.kind(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            recurrenceInterval = javaType.recurrenceInterval(),
            synchronizationTime = javaType.synchronizationTime(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.datashare.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            userName = javaType.userName(),
        )
    }
}
