@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A share data transfer object.
 * @property createdAt Time at which the share was created.
 * @property description Share description.
 * @property id The resource id of the azure resource
 * @property name Name of the azure resource
 * @property provisioningState Gets or sets the provisioning state
 * @property shareKind Share kind.
 * @property systemData System Data of the Azure resource.
 * @property terms Share terms.
 * @property type Type of the azure resource
 * @property userEmail Email of the user who created the resource
 * @property userName Name of the user who created the resource
 */
public data class GetShareResult(
    public val createdAt: String,
    public val description: String? = null,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val shareKind: String? = null,
    public val systemData: SystemDataResponse,
    public val terms: String? = null,
    public val type: String,
    public val userEmail: String,
    public val userName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datashare.outputs.GetShareResult):
            GetShareResult = GetShareResult(
            createdAt = javaType.createdAt(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            shareKind = javaType.shareKind().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.datashare.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            terms = javaType.terms().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            userEmail = javaType.userEmail(),
            userName = javaType.userName(),
        )
    }
}
